import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, PanelControlBase } from '@/studio-core';
import ContactService from '@/service/contact/contact-service';
import DataPanelService from './data-panel-panel-service';
import { FormItemModel } from '@/model/form-detail';
import DataPanelModel from './data-panel-panel-model';
import CodeListService from "@service/app/codelist-service";


/**
 * datapanel部件基类
 *
 * @export
 * @class PanelControlBase
 * @extends {DataPanelPanelBase}
 */
export class DataPanelPanelBase extends PanelControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof DataPanelPanelBase
     */
    protected controlType: string = 'PANEL';

    /**
     * 建构部件服务对象
     *
     * @type {DataPanelService}
     * @memberof DataPanelPanelBase
     */
    public service: DataPanelService = new DataPanelService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {ContactService}
     * @memberof DataPanelPanelBase
     */
    public appEntityService: ContactService = new ContactService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof DataPanelPanelBase
     */
    protected appDeName: string = 'contact';

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof DataPanel
     */
    public detailsModel: any = {
        customersizecode: new FormItemModel({ visible: true, disabled: false, enableCond: 3 }), 
        statuscode: new FormItemModel({ visible: true, disabled: false, enableCond: 3 }), 
        owneridyominame: new FormItemModel({ visible: true, disabled: false, enableCond: 3 }), 
        container1: new FormItemModel({ visible: true, disabled: false, enableCond: 3 }), 
    };

    /**
     * 面板逻辑
     *
     * @public
     * @param {{ name: string, newVal: any, oldVal: any }} { name, newVal, oldVal }
     * @memberof DataPanel
     */
    public panelLogic({ name, newVal, oldVal }: { name: string, newVal: any, oldVal: any }): void {
                




    }

    /**
     * 数据模型对象
     *
     * @type {DataPanelModel}
     * @memberof DataPanel
     */
    public dataModel: DataPanelModel = new DataPanelModel();

    /**
     * 界面行为
     *
     * @param {*} row
     * @param {*} tag
     * @param {*} $event
     * @memberof DataPanel
     */
    public async uiAction(row: any, tag: any, $event: any) {
        await this.computePanelData();
    }
}