import AuthService from '../auth-service';

/**
 * 潜在顾客权限服务对象基类
 *
 * @export
 * @class LeadAuthServiceBase
 * @extends {AuthService}
 */
export default class LeadAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  LeadAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  LeadAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof LeadAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}