import AuthService from '../auth-service';

/**
 * 权利权限服务对象基类
 *
 * @export
 * @class EntitlementAuthServiceBase
 * @extends {AuthService}
 */
export default class EntitlementAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  EntitlementAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EntitlementAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof EntitlementAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}