import AuthService from '../auth-service';

/**
 * 竞争对手权限服务对象基类
 *
 * @export
 * @class CompetitorAuthServiceBase
 * @extends {AuthService}
 */
export default class CompetitorAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  CompetitorAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  CompetitorAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof CompetitorAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}