import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import IBizListService from '@/service/ibiz-list/ibiz-list-service';
import QuickCreateService from './quick-create-form-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {QuickCreateEditFormBase}
 */
export class QuickCreateEditFormBase extends EditFormControlBase {

    /**
     * 建构部件服务对象
     *
     * @type {QuickCreateService}
     * @memberof QuickCreateEditFormBase
     */
    public service: QuickCreateService = new QuickCreateService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {IBizListService}
     * @memberof QuickCreateEditFormBase
     */
    public appEntityService: IBizListService = new IBizListService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof QuickCreateEditFormBase
     */
    protected appDeName: string = 'ibizlist';

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof QuickCreateEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        listname: null,
        membertype: null,
        type: null,
        purpose: null,
        source: null,
        transactioncurrencyname: null,
        cost: null,
        lastusedon: null,
        lockstatus: null,
        description: null,
        ownerid: null,
        owneridtype: null,
        owneridyominame: null,
        createman: null,
        createdate: null,
        updateman: null,
        updatedate: null,
        transactioncurrencyid: null,
        listid: null,
        ibizlist:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof QuickCreateEditFormBase
     */
    public rules: any = {
        srfupdatedate: [
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'blur' },
        ],
        srforikey: [
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfkey: [
            { required: false, type: 'string', message: '列表 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '列表 值不能为空', trigger: 'blur' },
        ],
        srfmajortext: [
            { required: false, type: 'string', message: '名称 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '名称 值不能为空', trigger: 'blur' },
        ],
        srftempmode: [
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfuf: [
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfdeid: [
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        srfsourcekey: [
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: ' 值不能为空', trigger: 'blur' },
        ],
        listname: [
            { required: true, type: 'string', message: '名称 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '名称 值不能为空', trigger: 'blur' },
        ],
        membertype: [
            { required: false, type: 'string', message: '目标对象 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '目标对象 值不能为空', trigger: 'blur' },
        ],
        type: [
            { required: true, type: 'number', message: '类型 值不能为空', trigger: 'change' },
            { required: true, type: 'number', message: '类型 值不能为空', trigger: 'blur' },
        ],
        purpose: [
            { required: false, type: 'string', message: '用途 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '用途 值不能为空', trigger: 'blur' },
        ],
        source: [
            { required: false, type: 'string', message: '来源 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '来源 值不能为空', trigger: 'blur' },
        ],
        transactioncurrencyname: [
            { required: false, type: 'string', message: '货币 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '货币 值不能为空', trigger: 'blur' },
        ],
        cost: [
            { required: false, type: 'number', message: '成本 值不能为空', trigger: 'change' },
            { required: false, type: 'number', message: '成本 值不能为空', trigger: 'blur' },
        ],
        lastusedon: [
            { required: false, type: 'string', message: '上次使用时间 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '上次使用时间 值不能为空', trigger: 'blur' },
        ],
        lockstatus: [
            { required: false, type: 'number', message: '已锁定 值不能为空', trigger: 'change' },
            { required: false, type: 'number', message: '已锁定 值不能为空', trigger: 'blur' },
        ],
        description: [
            { required: false, type: 'string', message: '说明 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '说明 值不能为空', trigger: 'blur' },
        ],
        ownerid: [
            { required: true, type: 'string', message: '负责人 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '负责人 值不能为空', trigger: 'blur' },
        ],
        owneridtype: [
            { required: true, type: 'string', message: '负责人类型 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '负责人类型 值不能为空', trigger: 'blur' },
        ],
        owneridyominame: [
            { required: true, type: 'string', message: '负责人 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '负责人 值不能为空', trigger: 'blur' },
        ],
        createman: [
            { required: false, type: 'string', message: '建立人 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '建立人 值不能为空', trigger: 'blur' },
        ],
        createdate: [
            { required: false, type: 'string', message: '建立时间 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '建立时间 值不能为空', trigger: 'blur' },
        ],
        updateman: [
            { required: false, type: 'string', message: '更新人 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '更新人 值不能为空', trigger: 'blur' },
        ],
        updatedate: [
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '更新时间 值不能为空', trigger: 'blur' },
        ],
        transactioncurrencyid: [
            { required: false, type: 'string', message: '货币 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '货币 值不能为空', trigger: 'blur' },
        ],
        listid: [
            { required: false, type: 'string', message: '列表 值不能为空', trigger: 'change' },
            { required: false, type: 'string', message: '列表 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof QuickCreateEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: 'list基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: 'entities.ibizlist.quickcreate_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this }),

        group2: new FormGroupPanelModel({ caption: '操作信息', detailType: 'GROUPPANEL', name: 'group2', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: 'entities.ibizlist.quickcreate_form', extractMode: 'ITEM', details: [] } }),

        formpage2: new FormPageModel({ caption: '其它', detailType: 'FORMPAGE', name: 'formpage2', visible: true, isShowCaption: true, form: this }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '列表', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        srfmajortext: new FormItemModel({ caption: '名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        listname: new FormItemModel({ caption: '名称', detailType: 'FORMITEM', name: 'listname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        membertype: new FormItemModel({ caption: '目标对象', detailType: 'FORMITEM', name: 'membertype', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        type: new FormItemModel({ caption: '类型', detailType: 'FORMITEM', name: 'type', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        purpose: new FormItemModel({ caption: '用途', detailType: 'FORMITEM', name: 'purpose', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        source: new FormItemModel({ caption: '来源', detailType: 'FORMITEM', name: 'source', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        transactioncurrencyname: new FormItemModel({ caption: '货币', detailType: 'FORMITEM', name: 'transactioncurrencyname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        cost: new FormItemModel({ caption: '成本', detailType: 'FORMITEM', name: 'cost', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        lastusedon: new FormItemModel({ caption: '上次使用时间', detailType: 'FORMITEM', name: 'lastusedon', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 2 }),

        lockstatus: new FormItemModel({ caption: '已锁定', detailType: 'FORMITEM', name: 'lockstatus', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        description: new FormItemModel({ caption: '说明', detailType: 'FORMITEM', name: 'description', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        ownerid: new FormItemModel({ caption: '负责人', detailType: 'FORMITEM', name: 'ownerid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        owneridtype: new FormItemModel({ caption: '负责人类型', detailType: 'FORMITEM', name: 'owneridtype', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        owneridyominame: new FormItemModel({ caption: '负责人', detailType: 'FORMITEM', name: 'owneridyominame', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        createman: new FormItemModel({ caption: '建立人', detailType: 'FORMITEM', name: 'createman', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        createdate: new FormItemModel({ caption: '建立时间', detailType: 'FORMITEM', name: 'createdate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        updateman: new FormItemModel({ caption: '更新人', detailType: 'FORMITEM', name: 'updateman', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        updatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'updatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        transactioncurrencyid: new FormItemModel({ caption: '货币', detailType: 'FORMITEM', name: 'transactioncurrencyid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        listid: new FormItemModel({ caption: '列表', detailType: 'FORMITEM', name: 'listid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        form: new FormTabPanelModel({ caption: 'form', detailType: 'TABPANEL', name: 'form', visible: true, isShowCaption: true, form: this, tabPages: [{ name: 'formpage1', index: 0, visible: true }, { name: 'formpage2', index: 1, visible: true }] }),
    };
}