import { ViewTool } from '@/utils';

/**
 * Setting 部件模型
 *
 * @export
 * @class SettingModel
 */
export default class SettingModel {

    /**
     * 菜单项集合
     *
     * @private
     * @type {any[]}
     * @memberof SettingModel
     */
    private items: any[] = [
                {
        	id: 'FDC4FD25-BAC5-467E-B000-5A118E2A3AFE',
        	name: 'menuitem1',
        	text: '链接角色',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '链接角色',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: 'fa fa-connectdevelop',
        	icon: '',
        	textcls: '',
        	appfunctag: 'Auto27',
        	appfuncyype: 'APPVIEW',
        	viewname: 'connection-role-grid-view',
        	resourcetag: '',
        }
        ,
    ];

	/**
	 * 应用功能集合
	 *
	 * @private
	 * @type {any[]}
	 * @memberof SettingModel
	 */
	private funcs: any[] = [
	];

	/**
	 * 根据当前路由查找激活菜单
	 *
	 * @param {*} route
	 * @returns {*}
	 * @memberof SettingModel
	 */
	public findActiveMenuByRoute(route: any): any {
		if (route) {
			const func = this.funcs.find((item: any) => {
				if (item.openmode === '') {
					const url: string = ViewTool.buildUpRoutePath(route, route.params, [], item.parameters, [], {});
					return url === route.fullPath;
				}
			});
            if (func) {
			    return this.findMenuByFuncTag(func.appfunctag);
            }
		}
	}

	/**
	 * 根据应用功能id查找菜单项
	 *
	 * @param {string} tag
	 * @param {any[]} [menus=this.items]
	 * @returns {*}
	 * @memberof SettingModel
	 */
	public findMenuByFuncTag(tag: string, menus: any[] = this.items): any {
		let menu: any;
		menus.every((item: any) => {
			if (item.appfunctag === tag) {
				menu = item;
				return false;
			}
			if (item.items) {
				menu = this.findMenuByFuncTag(tag, item.items);
				if (menu) {
					return false;
				}
			}
			return true;
		});
		return menu;
	}

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof SettingModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

	/**
	 * 根据名称获取菜单组
	 *
	 * @param {string} name
	 * @returns {*}
	 * @memberof SettingModel
	 */
	public getMenuGroup(name: string): any {
		return this.items.find((item: any) => Object.is(item.name, name));
	}

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof SettingModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}