import AuthService from '../auth-service';

/**
 * 连接角色权限服务对象基类
 *
 * @export
 * @class ConnectionRoleAuthServiceBase
 * @extends {AuthService}
 */
export default class ConnectionRoleAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  ConnectionRoleAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ConnectionRoleAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof ConnectionRoleAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}