import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import GoalService from '@/service/goal/goal-service';
import Info_GoalService from './info-goal-form-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {Info_GoalEditFormBase}
 */
export class Info_GoalEditFormBase extends EditFormControlBase {

    /**
     * 建构部件服务对象
     *
     * @type {Info_GoalService}
     * @memberof Info_GoalEditFormBase
     */
    public service: Info_GoalService = new Info_GoalService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {GoalService}
     * @memberof Info_GoalEditFormBase
     */
    public appEntityService: GoalService = new GoalService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof Info_GoalEditFormBase
     */
    protected appDeName: string = 'goal';

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof Info_GoalEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        title: null,
        parentgoalname: null,
        metricname: null,
        goalownerid: null,
        ownerid: null,
        fiscalperiodgoal: null,
        fiscalyear: null,
        fiscalperiod: null,
        goalstartdate: null,
        goalenddate: null,
        targetmoney: null,
        actualmoney: null,
        percentage: null,
        inprogressmoney: null,
        goalid: null,
        goal:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof Info_GoalEditFormBase
     */
    public rules: any = {
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof Info_GoalEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: 'entities.goal.info_goal_form', extractMode: 'ITEM', details: [] } }),

        grouppanel2: new FormGroupPanelModel({ caption: '分组面板', detailType: 'GROUPPANEL', name: 'grouppanel2', visible: false, isShowCaption: false, form: this, uiActionGroup: { caption: '', langbase: 'entities.goal.info_goal_form', extractMode: 'ITEM', details: [] } }),

        grouppanel3: new FormGroupPanelModel({ caption: '分组面板', detailType: 'GROUPPANEL', name: 'grouppanel3', visible: false, isShowCaption: false, form: this, uiActionGroup: { caption: '', langbase: 'entities.goal.info_goal_form', extractMode: 'ITEM', details: [] } }),

        grouppanel1: new FormGroupPanelModel({ caption: '时间段', detailType: 'GROUPPANEL', name: 'grouppanel1', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: 'entities.goal.info_goal_form', extractMode: 'ITEM', details: [] } }),

        grouppanel4: new FormGroupPanelModel({ caption: '详细信息', detailType: 'GROUPPANEL', name: 'grouppanel4', visible: true, isShowCaption: true, form: this, uiActionGroup: { caption: '', langbase: 'entities.goal.info_goal_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '目标', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        srfmajortext: new FormItemModel({ caption: '名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        title: new FormItemModel({ caption: '名称', detailType: 'FORMITEM', name: 'title', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        parentgoalname: new FormItemModel({ caption: '上级目标', detailType: 'FORMITEM', name: 'parentgoalname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        metricname: new FormItemModel({ caption: '目标度量', detailType: 'FORMITEM', name: 'metricname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        goalownerid: new FormItemModel({ caption: '目标负责人', detailType: 'FORMITEM', name: 'goalownerid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        ownerid: new FormItemModel({ caption: '经理', detailType: 'FORMITEM', name: 'ownerid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        fiscalperiodgoal: new FormItemModel({ caption: '目标期间类型', detailType: 'FORMITEM', name: 'fiscalperiodgoal', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        fiscalyear: new FormItemModel({ caption: '会计年度', detailType: 'FORMITEM', name: 'fiscalyear', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        fiscalperiod: new FormItemModel({ caption: '会计期间', detailType: 'FORMITEM', name: 'fiscalperiod', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        goalstartdate: new FormItemModel({ caption: '从', detailType: 'FORMITEM', name: 'goalstartdate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        goalenddate: new FormItemModel({ caption: '到', detailType: 'FORMITEM', name: 'goalenddate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        targetmoney: new FormItemModel({ caption: '目标值(金额)', detailType: 'FORMITEM', name: 'targetmoney', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        actualmoney: new FormItemModel({ caption: '实际值(金额)', detailType: 'FORMITEM', name: 'actualmoney', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        percentage: new FormItemModel({ caption: '已实现百分比', detailType: 'FORMITEM', name: 'percentage', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        inprogressmoney: new FormItemModel({ caption: '过程值(金额)', detailType: 'FORMITEM', name: 'inprogressmoney', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        goalid: new FormItemModel({ caption: '目标', detailType: 'FORMITEM', name: 'goalid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

    };

    /**
     * 表单逻辑
     *
     * @param {{ name: string, newVal: any, oldVal: any }} { name, newVal, oldVal }
     * @memberof Info_GoalEditFormBase
     */
    public formLogic({ name, newVal, oldVal }: { name: string, newVal: any, oldVal: any }): void {
                

        if (Object.is(name, '') || Object.is(name, 'fiscalperiodgoal')) {
            let ret = false;
            const _fiscalperiodgoal = this.data.fiscalperiodgoal;
            if (this.$verify.testCond(_fiscalperiodgoal, 'EQ', '')) {
                ret = true;
            }
            this.detailsModel.grouppanel2.setVisible(ret);
        }

        if (Object.is(name, '') || Object.is(name, 'fiscalperiodgoal')) {
            let ret = false;
            const _fiscalperiodgoal = this.data.fiscalperiodgoal;
            if (this.$verify.testCond(_fiscalperiodgoal, 'EQ', '0')) {
                ret = true;
            }
            this.detailsModel.grouppanel3.setVisible(ret);
        }



























    }
}