import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, MainControlBase } from '@/studio-core';
import ActivityPointerService from '@/service/activity-pointer/activity-pointer-service';
import ByRegardingObjectIdService from './by-regarding-object-id-panel-service';
import { FormItemModel } from '@/model/form-detail';
import ByRegardingObjectIdModel from './by-regarding-object-id-panel-model';
import CodeListService from "@service/app/codelist-service";


/**
 * dashboard_sysportlet2_list_itempanel部件基类
 *
 * @export
 * @class MainControlBase
 * @extends {ByRegardingObjectIdPanelBase}
 */
export class ByRegardingObjectIdPanelBase extends MainControlBase {

    /**
     * 建构部件服务对象
     *
     * @type {ByRegardingObjectIdService}
     * @memberof ByRegardingObjectIdPanelBase
     */
    public service: ByRegardingObjectIdService = new ByRegardingObjectIdService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {ActivityPointerService}
     * @memberof ByRegardingObjectIdPanelBase
     */
    public appEntityService: ActivityPointerService = new ActivityPointerService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof ByRegardingObjectIdPanelBase
     */
    protected appDeName: string = 'activitypointer';

    /**
     * 接口实现
     *
     * @returns {any[]}
     * @memberof ByRegardingObjectId
     */
    getDatas(): any[] {
        if (!this.panelData) {
            return [];
        }
        return [this.panelData];
    }

    /**
     * 接口实现
     *
     * @returns {*}
     * @memberof ByRegardingObjectId
     */
    getData() {
        return this.data;
    }

    /**
     * 父级部件引用
     *
     * @type {*}
     * @memberof ByRegardingObjectId
     */
    @Prop() public parentRef?: any;

    /**
     * 面板数据对象
     *
     * @type {*}
     * @memberof ByRegardingObjectId
     */
    @Prop() public inputData?: any;

    /**
     * 代码表服务对象
     *
     * @type {CodeListService}
     * @memberof ByRegardingObjectId
     */
    public codeListService:CodeListService = new CodeListService({ $store:this.$store });

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof ByRegardingObjectId
     */
    public detailsModel: any = {
        activitytypecode: new FormItemModel({ visible: true, disabled: false, enableCond: 3 }), 
        subject: new FormItemModel({ visible: true, disabled: false, enableCond: 3 }), 
        container1: new FormItemModel({ visible: true, disabled: false, enableCond: 3 }), 
    };

    /**
     * 面板逻辑
     *
     * @public
     * @param {{ name: string, newVal: any, oldVal: any }} { name, newVal, oldVal }
     * @memberof ByRegardingObjectId
     */
    public panelLogic({ name, newVal, oldVal }: { name: string, newVal: any, oldVal: any }): void {
                



    }

    /**
     * 数据模型对象
     *
     * @type {ByRegardingObjectIdModel}
     * @memberof ByRegardingObjectId
     */
    public dataModel:ByRegardingObjectIdModel = new ByRegardingObjectIdModel();

    /**
     * UI数据对象
     *
     * @type {*}
     * @memberof ByRegardingObjectId
     */
    public data:any = {};

    /**
     * 面板数据对象
     *
     * @type {*}
     * @memberof Mob
     */
    public panelData:any = null;

    /**
     * 监听数据对象
     *
     * @memberof ByRegardingObjectId
     */
    @Watch('inputData',{immediate:true})
    async onInputDataChange(newVal: any, oldVal: any){
        if(newVal){
            await this.computedUIData(newVal);
            this.panelLogic({ name: '', newVal: null, oldVal: null });
            this.$forceUpdate();
        }
    }

    /**
     * 计算UI展示数据
     * 
     * @param codelistArray 代码表模型数组
     * @memberof ByRegardingObjectId
     */
    public async computedUIData(newVal:any){
        let codelistArray:Array<any> = [];
        if((this.dataModel.getDataItems instanceof Function) && this.dataModel.getDataItems().length >0){
            this.dataModel.getDataItems().forEach((item:any) =>{
                if(item.codelist){
                    codelistArray.push(item.codelist);
                }
            })
            if(codelistArray.length >0){
                let res:any = await this.getAllCodeList(codelistArray);
                this.dataModel.getDataItems().forEach((item:any) =>{
                    if(item.codelist){
                        this.data[item.name] = res.get(item.codelist.tag).get(newVal[item.prop]);
                    }else{
                        this.data[item.name] = newVal[item.prop];
                    }
                })
            }else{
                this.dataModel.getDataItems().forEach((item:any) =>{
                    this.data[item.name] = newVal[item.prop];
                }) 
            }
        }
    }

    /**
     * 计算面板数据
     * 
     * @param codelistArray 代码表模型数组
     * @memberof Mob
     */
    public async computePanelData(){
        let codelistArray:Array<any> = [];
        let panelData:any = {};
        if((this.dataModel.getDataItems instanceof Function) && this.dataModel.getDataItems().length >0){
            this.dataModel.getDataItems().forEach((item:any) =>{
                if(item.codelist){
                    codelistArray.push(item.codelist);
                }
            })
            if(codelistArray.length >0){
                let res:any = await this.getAllCodeList(codelistArray,true);
                this.dataModel.getDataItems().forEach((item:any) =>{
                    if(item.codelist){
                        panelData[item.prop]  = res.get(item.codelist.tag).get(this.data[item.name]);
                    }else{
                        panelData[item.prop] = this.data[item.name];
                    }
                })
            }else{
                this.dataModel.getDataItems().forEach((item:any) =>{
                    panelData[item.prop] = this.data[item.name];
                }) 
            }
        }
         this.panelData = Object.assign(JSON.parse(JSON.stringify(this.inputData)),panelData);
    }

    /**
     * 获取所有代码表
     * 
     * @param codelistArray 代码表模型数组
     * @memberof ByRegardingObjectId
     */
    public getAllCodeList(codelistArray:Array<any>,reverse:boolean = false):Promise<any>{
        return new Promise((resolve:any,reject:any) =>{
            let codeListMap:Map<string,any> = new Map();
            let promiseArray:Array<any> = [];
            codelistArray.forEach((item:any) =>{
                if(!codeListMap.get(item.tag)){
                    promiseArray.push(this.getCodeList(item));
                    Promise.all(promiseArray).then((result:any) =>{
                        if(result && result.length >0){
                            result.forEach((codeList:any) =>{
                                let tempCodeListMap:Map<number,any> = new Map();
                                if(codeList.length >0){
                                    codeList.forEach((codeListItem:any) =>{
                                        if(reverse){
                                            tempCodeListMap.set(codeListItem.text,codeListItem.value);
                                        }else{
                                            tempCodeListMap.set(codeListItem.value,codeListItem.text);
                                        }
                                    })
                                }
                                codeListMap.set(item.tag,tempCodeListMap);       
                            })
                            resolve(codeListMap);
                        }
                    })
                }
            })
        })
    }

    /**
     * 获取代码表
     * 
     * @param codeListObject 传入代码表对象
     * @memberof ByRegardingObjectId
     */
    public getCodeList(codeListObject:any):Promise<any>{
        return new Promise((resolve:any,reject:any) =>{
            if(codeListObject.tag && Object.is(codeListObject.codelistType,"STATIC")){
                const codelist = this.$store.getters.getCodeList(codeListObject.tag);
                if (codelist) {
                    resolve([...JSON.parse(JSON.stringify(codelist.items))]);
                } else {
                    resolve([]);
                }
            }else if(codeListObject.tag && Object.is(codeListObject.codelistType,"DYNAMIC")){
                this.codeListService.getItems(codeListObject.tag).then((res:any) => {
                    resolve(res);
                }).catch((error:any) => {
                    resolve([]);
                });
            }
        })
    }

    /**
     * 界面行为
     *
     * @param {*} row
     * @param {*} tag
     * @param {*} $event
     * @memberof ByRegardingObjectId
     */
    public async uiAction(row: any, tag: any, $event: any) {
        await this.computePanelData();
    }

    /**
     * 打开编辑数据视图
     *
     * @type {any}
     * @memberof ByRegardingObjectId
     */
    public opendata(args: any[],fullargs?:any[],params?: any, $event?: any, xData?: any){
        if (this.parentRef.opendata && this.parentRef.opendata instanceof Function) {
            this.parentRef.opendata(args,fullargs,params, $event, xData);
        }
    }

    /**
     * 打开新建数据视图
     *
     * @type {any}
     * @memberof ByRegardingObjectId
     */
    public newdata(args: any[],fullargs?:any[], params?: any, $event?: any, xData?: any) {
        if (this.parentRef.newdata && this.parentRef.newdata instanceof Function) {
            this.parentRef.newdata(args,fullargs,params, $event, xData);
        }
    }
    
    /**
     * 删除
     *
     * @param {any[]} datas
     * @returns {Promise<any>}
     * @memberof ByRegardingObjectId
     */
    public async remove(datas: any[]): Promise<any> {
        if (this.parentRef.remove && this.parentRef.remove instanceof Function) {
            return this.parentRef.remove(datas);
        }
    }

    /**
     * 刷新
     *
     * @param {*} [opt={}]
     * @memberof Main
     */
    public refresh(opt: any = {}) {
        if (this.parentRef.refresh && this.parentRef.refresh instanceof Function) {
            this.parentRef.refresh(opt);
        }
    }

    
    /**
     * 设置面板编辑项值变更
     *  
     * @param data 面板数据
     * @param {{ name: string, value: any }} $event
     * @returns {void}
     * @memberof ByRegardingObjectId
     */
    public onPanelItemValueChange(data: any,$event: { name: string, value: any }): void {
        if (!$event) {
            return;
        }
        if (!$event.name || Object.is($event.name, '') || !data.hasOwnProperty($event.name)) {
            return;
        }
        data[$event.name] = $event.value;
        this.panelEditItemChange(data, $event.name, $event.value);
    }

    /**
     * 面板编辑项值变化
     *
     * @public
     * @param data 面板数据
     * @param property 编辑项名
     * @param value 编辑项值
     * @returns {void}
     * @memberof ByRegardingObjectId
     */
    public panelEditItemChange(data: any, property: string, value: any){
        // 面板数据变化事件
        if((this.dataModel.getDataItems instanceof Function) && this.dataModel.getDataItems().length >0){
            let modelitem =this.dataModel.getDataItems().find((item:any) =>{
                return item.name === property;
            }) 
            if(modelitem){
                this.$emit('panelDataChange',{[modelitem.prop]: value});
            }
        }
    }
}