import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, ListControllerBase } from '@/studio-core';
import ActivityPointerService from '@/service/activity-pointer/activity-pointer-service';
import ByParentKeyService from './by-parent-key-list-service';


/**
 * dashboard_sysportlet2_list部件基类
 *
 * @export
 * @class ListControllerBase
 * @extends {ByParentKeyListBase}
 */
export class ByParentKeyListBase extends ListControllerBase {

    /**
     * 建构部件服务对象
     *
     * @type {ByParentKeyService}
     * @memberof ByParentKeyListBase
     */
    public service: ByParentKeyService = new ByParentKeyService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {ActivityPointerService}
     * @memberof ByParentKeyListBase
     */
    public appEntityService: ActivityPointerService = new ActivityPointerService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof ByParentKeyListBase
     */
    protected appDeName: string = 'activitypointer';

    /**
     * 分页条数
     *
     * @type {number}
     * @memberof ByParentKeyListBase
     */
    public limit: number = 1000;

    /**
     * 排序方向
     *
     * @type {string}
     * @memberof ByParentKeyListBase
     */
    public minorSortDir: string = '';
}