import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import TaskService from '@/service/task/task-service';
import QuickCreateService from './quick-create-form-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {QuickCreateEditFormBase}
 */
export class QuickCreateEditFormBase extends EditFormControlBase {

    /**
     * 建构部件服务对象
     *
     * @type {QuickCreateService}
     * @memberof QuickCreateEditFormBase
     */
    public service: QuickCreateService = new QuickCreateService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {TaskService}
     * @memberof QuickCreateEditFormBase
     */
    public appEntityService: TaskService = new TaskService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof QuickCreateEditFormBase
     */
    protected appDeName: string = 'task';

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof QuickCreateEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        ownerid: null,
        owneridtype: null,
        owneridyominame: null,
        subject: null,
        description: null,
        scheduledend: null,
        actualdurationminutes: null,
        prioritycode: null,
        regardingobjectid: null,
        regardingobjectidyominame: null,
        regardingobjecttypecode: null,
        activityid: null,
        task:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof QuickCreateEditFormBase
     */
    public rules: any = {
        ownerid: [
            { required: true, type: 'string', message: '负责人 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '负责人 值不能为空', trigger: 'blur' },
        ],
        owneridtype: [
            { required: true, type: 'string', message: '负责人类型 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '负责人类型 值不能为空', trigger: 'blur' },
        ],
        owneridyominame: [
            { required: true, type: 'string', message: '负责人 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '负责人 值不能为空', trigger: 'blur' },
        ],
        subject: [
            { required: true, type: 'string', message: '主题 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '主题 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof QuickCreateEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: 'task基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', langbase: 'entities.task.quickcreate_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '任务​​', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        srfmajortext: new FormItemModel({ caption: '主题', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        ownerid: new FormItemModel({ caption: '负责人', detailType: 'FORMITEM', name: 'ownerid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        owneridtype: new FormItemModel({ caption: '负责人类型', detailType: 'FORMITEM', name: 'owneridtype', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        owneridyominame: new FormItemModel({ caption: '负责人', detailType: 'FORMITEM', name: 'owneridyominame', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        subject: new FormItemModel({ caption: '主题', detailType: 'FORMITEM', name: 'subject', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        description: new FormItemModel({ caption: '说明', detailType: 'FORMITEM', name: 'description', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        scheduledend: new FormItemModel({ caption: '截止日期', detailType: 'FORMITEM', name: 'scheduledend', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        actualdurationminutes: new FormItemModel({ caption: '持续时间', detailType: 'FORMITEM', name: 'actualdurationminutes', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        prioritycode: new FormItemModel({ caption: '优先级', detailType: 'FORMITEM', name: 'prioritycode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        regardingobjectid: new FormItemModel({ caption: '关于', detailType: 'FORMITEM', name: 'regardingobjectid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        regardingobjectidyominame: new FormItemModel({ caption: '关于', detailType: 'FORMITEM', name: 'regardingobjectidyominame', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        regardingobjecttypecode: new FormItemModel({ caption: 'RegardingObjectTypeCode', detailType: 'FORMITEM', name: 'regardingobjecttypecode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        activityid: new FormItemModel({ caption: '任务​​', detailType: 'FORMITEM', name: 'activityid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

    };

    /**
     * 新建默认值
     * @memberof QuickCreateEditFormBase
     */
    public createDefault(){                    
        if (this.data.hasOwnProperty('regardingobjectid')) {
            this.data['regardingobjectid'] = this.viewparams['regardingobjectid'];
        }
        if (this.data.hasOwnProperty('regardingobjecttypecode')) {
            this.data['regardingobjecttypecode'] = this.viewparams['regardingobjecttypecode'];
        }
    }
}