import { Subject } from 'rxjs';
import { TabExpViewBase } from '@/studio-core';
import AccountService from '@/service/account/account-service';
import TabExpViewEngine from '@engine/view/tab-exp-view-engine';

/**
 * 客户信息视图基类
 *
 * @export
 * @class AccountStatusTabViewBase
 * @extends {TabExpViewBase}
 */
export class AccountStatusTabViewBase extends TabExpViewBase {

    /**
     * 实体服务对象
     *
     * @type {AccountService}
     * @memberof AccountStatusTabViewBase
     */
    protected appEntityService: AccountService = new AccountService;


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof AccountStatusTabViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof AccountStatusTabViewBase
     */
    protected model: any = {
        srfCaption: 'entities.account.views.statustabview.caption',
        srfTitle: 'entities.account.views.statustabview.title',
        srfSubTitle: 'entities.account.views.statustabview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof AccountStatusTabViewBase
     */
    protected containerModel: any = {
        view_tabexppanel: { name: 'tabexppanel', type: 'TABEXPPANEL' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '25bf5f8c2ebd1ce2be6d06717ed08a96';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof AccountStatusTabViewBase
     */
    public engine: TabExpViewEngine = new TabExpViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof AccountStatusTabViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            keyPSDEField: 'account',
            majorPSDEField: 'accountname',
            isLoadDefault: true,
        });
    }



    /**
     * 加载模型
     *
     * @protected
     * @memberof AccountStatusTabViewBase
     */
    protected async loadModel(): Promise<any> {
        if(this.context.account){
            this.appEntityService.getDataInfo(JSON.parse(JSON.stringify(this.context)),{},false).then((response:any) =>{
                if (!response || response.status !== 200) {
                    return;
                }
                const { data: _data } = response;
                if (_data.accountname) {
                    Object.assign(this.model, { dataInfo: _data.accountname });
                    if (this.$tabPageExp) {
                        this.$tabPageExp.setCurPageCaption(this.model.srfTitle, this.model.srfTitle, this.model.dataInfo);
                    }
                    if(this.$route){
                        this.$route.meta.info = this.model.dataInfo;
                    }
                    Object.assign(this.model, { srfTitle: `${this.$t(this.model.srfTitle)} - ${this.model.dataInfo}` });
                    this.$appService.navHistory.setCaption({ route: this.$route, info: this.model.dataInfo });
                }
            })
        }
    }


}