import { Subject } from 'rxjs';
import { PickupGridViewBase } from '@/studio-core';
import AccountService from '@/service/account/account-service';
import PickupGridViewEngine from '@engine/view/pickup-grid-view-engine';

/**
 * 客户选择表格视图视图基类
 *
 * @export
 * @class AccountInnerPickupGridViewBase
 * @extends {PickupGridViewBase}
 */
export class AccountInnerPickupGridViewBase extends PickupGridViewBase {

    /**
     * 实体服务对象
     *
     * @type {AccountService}
     * @memberof AccountInnerPickupGridViewBase
     */
    protected appEntityService: AccountService = new AccountService;


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof AccountInnerPickupGridViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof AccountInnerPickupGridViewBase
     */
    protected model: any = {
        srfCaption: 'entities.account.views.innerpickupgridview.caption',
        srfTitle: 'entities.account.views.innerpickupgridview.title',
        srfSubTitle: 'entities.account.views.innerpickupgridview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof AccountInnerPickupGridViewBase
     */
    protected containerModel: any = {
        view_grid: { name: 'grid', type: 'GRID' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '7217511947b8833ba5683e54c06b0271';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof AccountInnerPickupGridViewBase
     */
    public engine: PickupGridViewEngine = new PickupGridViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof AccountInnerPickupGridViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            grid: this.$refs.grid,
            keyPSDEField: 'account',
            majorPSDEField: 'accountname',
            isLoadDefault: true,
        });
    }

    /**
     * grid 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof AccountInnerPickupGridViewBase
     */
    public grid_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'selectionchange', $event);
    }

    /**
     * grid 部件 beforeload 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof AccountInnerPickupGridViewBase
     */
    public grid_beforeload($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'beforeload', $event);
    }

    /**
     * grid 部件 rowdblclick 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof AccountInnerPickupGridViewBase
     */
    public grid_rowdblclick($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'rowdblclick', $event);
    }

    /**
     * grid 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof AccountInnerPickupGridViewBase
     */
    public grid_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('grid', 'load', $event);
    }



    /**
     * 是否展开搜索表单
     *
     * @protected
     * @type {boolean}
     * @memberof AccountInnerPickupGridViewBase
     */
    protected isExpandSearchForm: boolean = true;


}