import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import WebSiteModel from './web-site-appmenu-model';


/**
 * WebSite 部件服务对象
 *
 * @export
 * @class WebSiteService
 */
export default class WebSiteService extends ControlService {

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof WebSiteService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of WebSiteService.
     * 
     * @param {*} [opts={}]
     * @memberof WebSiteService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new WebSiteModel();
    }

    /**
     * 获取数据
     *
     * @returns {Promise<any>}
     * @memberof WebSite
     */
    @Errorlog
    public get(params: any = {}): Promise<any> {
        return Http.getInstance().get('v7/web-siteappmenu', params);
    }

}