/**
 * WebSite 部件模型
 *
 * @export
 * @class WebSiteModel
 */
export default class WebSiteModel {

    /**
     * 菜单项集合
     *
     * @private
     * @type {any[]}
     * @memberof WebSiteModel
     */
    private items: any[] = [
                {
        	id: '76a02e75378c93c639848db5cecd899f',
        	name: 'user_menus',
        	text: '用户菜单',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '用户菜单',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        	items: [
                		        {
                	id: '38b48a5764b49e99055b94d4aba5084c',
                	name: 'menuitem3',
                	text: '设置',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '设置',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-newspaper-o',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                }
                ,
        	],
        }
        ,
                {
        	id: '5b86b0f04da33f35d00480b0e218a595',
        	name: 'top_menus',
        	text: '顶部菜单',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '顶部菜单',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
                {
        	id: 'b2043430ad0f0a7401b9651b6ab6cb0a',
        	name: 'left_exp',
        	text: '左侧菜单',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '左侧菜单',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        	items: [
                		        {
                	id: 'ae69008e3600985fa6b342325776b09f',
                	name: 'menuitem17',
                	text: '站点管理',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '站点管理',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: true,
                	iconcls: 'fa fa-delicious',
                	icon: '',
                	textcls: '',
                	appfunctag: '_2',
                	appfuncyype: 'APPVIEW',
                	viewname: 'web-site-grid-view',
                	resourcetag: '',
                }
                ,
                		        {
                	id: '40b094ff64c0bfbb46e5c982e3336bba',
                	name: 'menuitem1',
                	text: '站点频道',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '站点频道',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-trello',
                	icon: '',
                	textcls: '',
                	appfunctag: '_3',
                	appfuncyype: 'APPVIEW',
                	viewname: 'web-site-channel-grid-view',
                	resourcetag: '',
                }
                ,
                		        {
                	id: '3a0f43c1a409e1154f5879e6d2bb2326',
                	name: 'menuitem5',
                	text: '站点内容',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '站点内容',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-tasks',
                	icon: '',
                	textcls: '',
                	appfunctag: '_5',
                	appfuncyype: 'APPVIEW',
                	viewname: 'web-site-content-grid-view',
                	resourcetag: '',
                }
                ,
                		        {
                	id: 'ad8f36742763bfb5ddc69424e5e7934d',
                	name: 'menuitem2',
                	text: '站点资源',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '站点资源',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-database',
                	icon: '',
                	textcls: '',
                	appfunctag: '_4',
                	appfuncyype: 'APPVIEW',
                	viewname: 'web-site-resource-grid-view',
                	resourcetag: '',
                }
                ,
        	],
        }
        ,
                {
        	id: 'ca415e7ca15a21da8e038cd3f3e01afd',
        	name: 'bottom_exp',
        	text: '底部内容',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '底部内容',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
                {
        	id: 'c5e0a6afa006948a76b1a56e54ccec14',
        	name: 'footer_left',
        	text: '底部左侧',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '底部左侧',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
                {
        	id: '8c898109f2c2544963b26e2b63d1951b',
        	name: 'footer_center',
        	text: '底部中间',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '底部中间',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
                {
        	id: '44a9e9e70d25e03bd8f31bcd7b9e325e',
        	name: 'footer_right',
        	text: '底部右侧',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '底部右侧',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
    ];

	/**
	 * 应用功能集合
	 *
	 * @private
	 * @type {any[]}
	 * @memberof WebSiteModel
	 */
	private funcs: any[] = [
        {
            appfunctag: '_3',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'websitechannelgridview',
            deResParameters: [],
            routepath: '/website/:website?/websitechannels/:websitechannel?/gridview/:gridview?',
            parameters: [
                { pathName: 'websitechannels', parameterName: 'websitechannel' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_5',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'websitecontentgridview',
            deResParameters: [],
            routepath: '/website/:website?/websitecontents/:websitecontent?/gridview/:gridview?',
            parameters: [
                { pathName: 'websitecontents', parameterName: 'websitecontent' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_4',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'websiteresourcegridview',
            deResParameters: [],
            routepath: '/website/:website?/websiteresources/:websiteresource?/gridview/:gridview?',
            parameters: [
                { pathName: 'websiteresources', parameterName: 'websiteresource' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_2',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'websitegridview',
            deResParameters: [],
            routepath: '/website/:website?/websites/:website?/gridview/:gridview?',
            parameters: [
                { pathName: 'websites', parameterName: 'website' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
	];

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof WebSiteModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

	/**
	 * 根据名称获取菜单组
	 *
	 * @param {string} name
	 * @returns {*}
	 * @memberof WebSiteModel
	 */
	public getMenuGroup(name: string): any {
		return this.items.find((item: any) => Object.is(item.name, name));
	}

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof WebSiteModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}