import { Vue } from 'vue-property-decorator';

/**
 * 应用菜单基类
 */
export class WebSiteBase extends Vue {

    /**
     * 菜单点击
     *
     * @protected
     * @param {*} item 菜单数据
     * @memberof WebSite
     */
    protected click(item: any) {
        if (item) {
            let judge = true;
            switch (item.appfunctag) {
                case '_3': 
                    this.click_3(item); break;
                case '_5': 
                    this.click_5(item); break;
                case '_4': 
                    this.click_4(item); break;
                case '_2': 
                    this.click_2(item); break;
                default:
                    judge = false;
                    console.warn('未指定应用功能');
            }
            if (judge) {
                this.$appService.navHistory.reset();
            }
        }
    }
    
    /**
     * 频道
     *
     * @param {*} [item={}]
     * @memberof WebSite
     */
    public click_3(item: any = {}) {
        const viewparam: any = {};
        Object.assign(viewparam, {});
        const deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'websitechannels', parameterName: 'websitechannel' },
            { pathName: 'gridview', parameterName: 'gridview' },
        ];
        const path: string = this.$viewTool.buildUpRoutePath(this.$route, {}, deResParameters, parameters, [], viewparam);
        if(Object.is(this.$route.fullPath,path)){
            return;
        }
        this.$nextTick(function(){
            this.$router.push(path);
        })
    }
    
    /**
     * 内容
     *
     * @param {*} [item={}]
     * @memberof WebSite
     */
    public click_5(item: any = {}) {
        const viewparam: any = {};
        Object.assign(viewparam, {});
        const deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'websitecontents', parameterName: 'websitecontent' },
            { pathName: 'gridview', parameterName: 'gridview' },
        ];
        const path: string = this.$viewTool.buildUpRoutePath(this.$route, {}, deResParameters, parameters, [], viewparam);
        if(Object.is(this.$route.fullPath,path)){
            return;
        }
        this.$nextTick(function(){
            this.$router.push(path);
        })
    }
    
    /**
     * 功能名称
     *
     * @param {*} [item={}]
     * @memberof WebSite
     */
    public click_4(item: any = {}) {
        const viewparam: any = {};
        Object.assign(viewparam, {});
        const deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'websiteresources', parameterName: 'websiteresource' },
            { pathName: 'gridview', parameterName: 'gridview' },
        ];
        const path: string = this.$viewTool.buildUpRoutePath(this.$route, {}, deResParameters, parameters, [], viewparam);
        if(Object.is(this.$route.fullPath,path)){
            return;
        }
        this.$nextTick(function(){
            this.$router.push(path);
        })
    }
    
    /**
     * 站点
     *
     * @param {*} [item={}]
     * @memberof WebSite
     */
    public click_2(item: any = {}) {
        const viewparam: any = {};
        Object.assign(viewparam, {});
        const deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'websites', parameterName: 'website' },
            { pathName: 'gridview', parameterName: 'gridview' },
        ];
        const path: string = this.$viewTool.buildUpRoutePath(this.$route, {}, deResParameters, parameters, [], viewparam);
        if(Object.is(this.$route.fullPath,path)){
            return;
        }
        this.$nextTick(function(){
            this.$router.push(path);
        })
    }

    /**
     * 绘制内容
     *
     * @private
     * @memberof WebSite
     */
    public render(): any {
        return <span style="display: none;"/>
    }

}