import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 站点服务对象基类
 *
 * @export
 * @class WebSiteServiceBase
 * @extends {EntityServie}
 */
export default class WebSiteServiceBase extends EntityService {

    /**
     * Creates an instance of  WebSiteServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  WebSiteServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof WebSiteServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='website';
        this.APPDEKEY = 'websiteid';
        this.APPDENAME = 'websites';
        this.APPDETEXT = 'websitename';
        this.APPNAME = 'website';
        this.SYSTEMNAME = 'ibizbusinesscentral';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/websites/${context.website}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let websitecontentsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents'),'undefined')){
            websitecontentsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents') as any);
            if(websitecontentsData && websitecontentsData.length && websitecontentsData.length > 0){
                websitecontentsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitecontentid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitecontents = websitecontentsData;
        let websitechannelsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitechannels'),'undefined')){
            websitechannelsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitechannels') as any);
            if(websitechannelsData && websitechannelsData.length && websitechannelsData.length > 0){
                websitechannelsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitechannelid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitechannels = websitechannelsData;
        let websiteresourcesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websiteresources'),'undefined')){
            websiteresourcesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websiteresources') as any);
            if(websiteresourcesData && websiteresourcesData.length && websiteresourcesData.length > 0){
                websiteresourcesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websiteresourceid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websiteresources = websiteresourcesData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/websites`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_websitechannels',JSON.stringify(res.data.websitechannels));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_websiteresources',JSON.stringify(res.data.websiteresources));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let websitecontentsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents'),'undefined')){
            websitecontentsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents') as any);
            if(websitecontentsData && websitecontentsData.length && websitecontentsData.length > 0){
                websitecontentsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitecontentid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitecontents = websitecontentsData;
        let websitechannelsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitechannels'),'undefined')){
            websitechannelsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitechannels') as any);
            if(websitechannelsData && websitechannelsData.length && websitechannelsData.length > 0){
                websitechannelsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitechannelid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitechannels = websitechannelsData;
        let websiteresourcesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websiteresources'),'undefined')){
            websiteresourcesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websiteresources') as any);
            if(websiteresourcesData && websiteresourcesData.length && websiteresourcesData.length > 0){
                websiteresourcesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websiteresourceid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websiteresources = websiteresourcesData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/websites/${context.website}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            this.tempStorage.setItem(context.srfsessionkey+'_websitechannels',JSON.stringify(res.data.websitechannels));
            this.tempStorage.setItem(context.srfsessionkey+'_websiteresources',JSON.stringify(res.data.websiteresources));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/websites/${context.website}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/websites/${context.website}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            this.tempStorage.setItem(context.srfsessionkey+'_websitechannels',JSON.stringify(res.data.websitechannels));
            this.tempStorage.setItem(context.srfsessionkey+'_websiteresources',JSON.stringify(res.data.websiteresources));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/websites/getdraft`,isloading);
        res.data.website = data.website;
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            this.tempStorage.setItem(context.srfsessionkey+'_websitechannels',JSON.stringify(res.data.websitechannels));
            this.tempStorage.setItem(context.srfsessionkey+'_websiteresources',JSON.stringify(res.data.websiteresources));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/websites/${context.website}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let websitecontentsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents'),'undefined')){
            websitecontentsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents') as any);
            if(websitecontentsData && websitecontentsData.length && websitecontentsData.length > 0){
                websitecontentsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitecontentid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitecontents = websitecontentsData;
        let websitechannelsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitechannels'),'undefined')){
            websitechannelsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitechannels') as any);
            if(websitechannelsData && websitechannelsData.length && websitechannelsData.length > 0){
                websitechannelsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitechannelid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitechannels = websitechannelsData;
        let websiteresourcesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websiteresources'),'undefined')){
            websiteresourcesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websiteresources') as any);
            if(websiteresourcesData && websiteresourcesData.length && websiteresourcesData.length > 0){
                websiteresourcesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websiteresourceid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websiteresources = websiteresourcesData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/websites/${context.website}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            this.tempStorage.setItem(context.srfsessionkey+'_websitechannels',JSON.stringify(res.data.websitechannels));
            this.tempStorage.setItem(context.srfsessionkey+'_websiteresources',JSON.stringify(res.data.websiteresources));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/websites/fetchdefault`,tempData,isloading);
    }
}