import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 站点频道服务对象基类
 *
 * @export
 * @class WebSiteChannelServiceBase
 * @extends {EntityServie}
 */
export default class WebSiteChannelServiceBase extends EntityService {

    /**
     * Creates an instance of  WebSiteChannelServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  WebSiteChannelServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof WebSiteChannelServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='websitechannel';
        this.APPDEKEY = 'websitechannelid';
        this.APPDENAME = 'websitechannels';
        this.APPDETEXT = 'websitechannelname';
        this.APPNAME = 'website';
        this.SYSTEMNAME = 'ibizbusinesscentral';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteChannelServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.website && context.websitechannel){
            return Http.getInstance().get(`/websites/${context.website}/websitechannels/${context.websitechannel}/select`,isloading);
        }
            return Http.getInstance().get(`/websitechannels/${context.websitechannel}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteChannelServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.website && true){
            let masterData:any = {};
        let websitecontentsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents'),'undefined')){
            websitecontentsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents') as any);
            if(websitecontentsData && websitecontentsData.length && websitecontentsData.length > 0){
                websitecontentsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitecontentid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitecontents = websitecontentsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/websites/${context.website}/websitechannels`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            return res;
        }
        let masterData:any = {};
        let websitecontentsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents'),'undefined')){
            websitecontentsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents') as any);
            if(websitecontentsData && websitecontentsData.length && websitecontentsData.length > 0){
                websitecontentsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitecontentid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitecontents = websitecontentsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/websitechannels`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteChannelServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.website && context.websitechannel){
            let masterData:any = {};
        let websitecontentsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents'),'undefined')){
            websitecontentsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents') as any);
            if(websitecontentsData && websitecontentsData.length && websitecontentsData.length > 0){
                websitecontentsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitecontentid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitecontents = websitecontentsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/websites/${context.website}/websitechannels/${context.websitechannel}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            return res;
        }
        let masterData:any = {};
        let websitecontentsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents'),'undefined')){
            websitecontentsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents') as any);
            if(websitecontentsData && websitecontentsData.length && websitecontentsData.length > 0){
                websitecontentsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitecontentid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitecontents = websitecontentsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/websitechannels/${context.websitechannel}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteChannelServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.website && context.websitechannel){
            return Http.getInstance().delete(`/websites/${context.website}/websitechannels/${context.websitechannel}`,isloading);
        }
            return Http.getInstance().delete(`/websitechannels/${context.websitechannel}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteChannelServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.website && context.websitechannel){
            let res:any = await Http.getInstance().get(`/websites/${context.website}/websitechannels/${context.websitechannel}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            return res;
        }
            let res:any = await Http.getInstance().get(`/websitechannels/${context.websitechannel}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteChannelServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.website && true){
            let res:any = await Http.getInstance().get(`/websites/${context.website}/websitechannels/getdraft`,isloading);
            res.data.websitechannel = data.websitechannel;
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            return res;
        }
        let res:any = await  Http.getInstance().get(`/websitechannels/getdraft`,isloading);
        res.data.websitechannel = data.websitechannel;
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteChannelServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.website && context.websitechannel){
            let masterData:any = {};
        let websitecontentsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents'),'undefined')){
            websitecontentsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents') as any);
            if(websitecontentsData && websitecontentsData.length && websitecontentsData.length > 0){
                websitecontentsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitecontentid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitecontents = websitecontentsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/websites/${context.website}/websitechannels/${context.websitechannel}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            return res;
        }
            return Http.getInstance().post(`/websitechannels/${context.websitechannel}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteChannelServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.website && context.websitechannel){
            let masterData:any = {};
        let websitecontentsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents'),'undefined')){
            websitecontentsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents') as any);
            if(websitecontentsData && websitecontentsData.length && websitecontentsData.length > 0){
                websitecontentsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitecontentid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitecontents = websitecontentsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/websites/${context.website}/websitechannels/${context.websitechannel}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            return res;
        }
        let masterData:any = {};
        let websitecontentsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents'),'undefined')){
            websitecontentsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_websitecontents') as any);
            if(websitecontentsData && websitecontentsData.length && websitecontentsData.length > 0){
                websitecontentsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.websitecontentid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.websitecontents = websitecontentsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/websitechannels/${context.websitechannel}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_websitecontents',JSON.stringify(res.data.websitecontents));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof WebSiteChannelServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.website && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/websites/${context.website}/websitechannels/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/websitechannels/fetchdefault`,tempData,isloading);
    }
}