import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 订单服务对象基类
 *
 * @export
 * @class SalesOrderServiceBase
 * @extends {EntityServie}
 */
export default class SalesOrderServiceBase extends EntityService {

    /**
     * Creates an instance of  SalesOrderServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  SalesOrderServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof SalesOrderServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='salesorder';
        this.APPDEKEY = 'salesorderid';
        this.APPDENAME = 'salesorders';
        this.APPDETEXT = 'salesordername';
        this.APPNAME = 'crm';
        this.SYSTEMNAME = 'ibizbusinesscentral';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SalesOrderServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/salesorders/${context.salesorder}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SalesOrderServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let salesorderdetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_salesorderdetails'),'undefined')){
            salesorderdetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_salesorderdetails') as any);
            if(salesorderdetailsData && salesorderdetailsData.length && salesorderdetailsData.length > 0){
                salesorderdetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.salesorderdetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.salesorderdetails = salesorderdetailsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/salesorders`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_salesorderdetails',JSON.stringify(res.data.salesorderdetails));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SalesOrderServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let salesorderdetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_salesorderdetails'),'undefined')){
            salesorderdetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_salesorderdetails') as any);
            if(salesorderdetailsData && salesorderdetailsData.length && salesorderdetailsData.length > 0){
                salesorderdetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.salesorderdetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.salesorderdetails = salesorderdetailsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/salesorders/${context.salesorder}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_salesorderdetails',JSON.stringify(res.data.salesorderdetails));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SalesOrderServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/salesorders/${context.salesorder}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SalesOrderServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/salesorders/${context.salesorder}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_salesorderdetails',JSON.stringify(res.data.salesorderdetails));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SalesOrderServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/salesorders/getdraft`,isloading);
        res.data.salesorder = data.salesorder;
            this.tempStorage.setItem(context.srfsessionkey+'_salesorderdetails',JSON.stringify(res.data.salesorderdetails));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SalesOrderServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/salesorders/${context.salesorder}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SalesOrderServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let salesorderdetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_salesorderdetails'),'undefined')){
            salesorderdetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_salesorderdetails') as any);
            if(salesorderdetailsData && salesorderdetailsData.length && salesorderdetailsData.length > 0){
                salesorderdetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.salesorderdetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.salesorderdetails = salesorderdetailsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/salesorders/${context.salesorder}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_salesorderdetails',JSON.stringify(res.data.salesorderdetails));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SalesOrderServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/salesorders/fetchdefault`,tempData,isloading);
    }
}