import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 目标服务对象基类
 *
 * @export
 * @class GoalServiceBase
 * @extends {EntityServie}
 */
export default class GoalServiceBase extends EntityService {

    /**
     * Creates an instance of  GoalServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  GoalServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof GoalServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='goal';
        this.APPDEKEY = 'goalid';
        this.APPDENAME = 'goals';
        this.APPDETEXT = 'title';
        this.APPNAME = 'crm';
        this.SYSTEMNAME = 'ibizbusinesscentral';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof GoalServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/goals/${context.goal}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof GoalServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let goalsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_goals'),'undefined')){
            goalsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_goals') as any);
            if(goalsData && goalsData.length && goalsData.length > 0){
                goalsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.goalid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.goals = goalsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/goals`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_goals',JSON.stringify(res.data.goals));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof GoalServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let goalsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_goals'),'undefined')){
            goalsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_goals') as any);
            if(goalsData && goalsData.length && goalsData.length > 0){
                goalsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.goalid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.goals = goalsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/goals/${context.goal}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_goals',JSON.stringify(res.data.goals));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof GoalServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/goals/${context.goal}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof GoalServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/goals/${context.goal}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_goals',JSON.stringify(res.data.goals));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof GoalServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/goals/getdraft`,isloading);
        res.data.goal = data.goal;
            this.tempStorage.setItem(context.srfsessionkey+'_goals',JSON.stringify(res.data.goals));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof GoalServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/goals/${context.goal}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof GoalServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let goalsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_goals'),'undefined')){
            goalsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_goals') as any);
            if(goalsData && goalsData.length && goalsData.length > 0){
                goalsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.goalid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.goals = goalsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/goals/${context.goal}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_goals',JSON.stringify(res.data.goals));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof GoalServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/goals/fetchdefault`,tempData,isloading);
    }
}