import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 市场活动服务对象基类
 *
 * @export
 * @class CampaignServiceBase
 * @extends {EntityServie}
 */
export default class CampaignServiceBase extends EntityService {

    /**
     * Creates an instance of  CampaignServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  CampaignServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof CampaignServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='campaign';
        this.APPDEKEY = 'campaignid';
        this.APPDENAME = 'campaigns';
        this.APPDETEXT = 'campaignname';
        this.APPNAME = 'crm';
        this.SYSTEMNAME = 'ibizbusinesscentral';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof CampaignServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/campaigns/${context.campaign}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof CampaignServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let campaigncampaignsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_campaigncampaigns'),'undefined')){
            campaigncampaignsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_campaigncampaigns') as any);
            if(campaigncampaignsData && campaigncampaignsData.length && campaigncampaignsData.length > 0){
                campaigncampaignsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.relationshipsid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.campaigncampaigns = campaigncampaignsData;
        let leadsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_leads'),'undefined')){
            leadsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_leads') as any);
            if(leadsData && leadsData.length && leadsData.length > 0){
                leadsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.leadid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.leads = leadsData;
        let campaignlistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_campaignlists'),'undefined')){
            campaignlistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_campaignlists') as any);
            if(campaignlistsData && campaignlistsData.length && campaignlistsData.length > 0){
                campaignlistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.relationshipsid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.campaignlists = campaignlistsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/campaigns`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_campaigncampaigns',JSON.stringify(res.data.campaigncampaigns));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_leads',JSON.stringify(res.data.leads));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_campaignlists',JSON.stringify(res.data.campaignlists));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof CampaignServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let campaigncampaignsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_campaigncampaigns'),'undefined')){
            campaigncampaignsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_campaigncampaigns') as any);
            if(campaigncampaignsData && campaigncampaignsData.length && campaigncampaignsData.length > 0){
                campaigncampaignsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.relationshipsid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.campaigncampaigns = campaigncampaignsData;
        let leadsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_leads'),'undefined')){
            leadsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_leads') as any);
            if(leadsData && leadsData.length && leadsData.length > 0){
                leadsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.leadid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.leads = leadsData;
        let campaignlistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_campaignlists'),'undefined')){
            campaignlistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_campaignlists') as any);
            if(campaignlistsData && campaignlistsData.length && campaignlistsData.length > 0){
                campaignlistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.relationshipsid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.campaignlists = campaignlistsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/campaigns/${context.campaign}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_campaigncampaigns',JSON.stringify(res.data.campaigncampaigns));
            this.tempStorage.setItem(context.srfsessionkey+'_leads',JSON.stringify(res.data.leads));
            this.tempStorage.setItem(context.srfsessionkey+'_campaignlists',JSON.stringify(res.data.campaignlists));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof CampaignServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/campaigns/${context.campaign}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof CampaignServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/campaigns/${context.campaign}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_campaigncampaigns',JSON.stringify(res.data.campaigncampaigns));
            this.tempStorage.setItem(context.srfsessionkey+'_leads',JSON.stringify(res.data.leads));
            this.tempStorage.setItem(context.srfsessionkey+'_campaignlists',JSON.stringify(res.data.campaignlists));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof CampaignServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/campaigns/getdraft`,isloading);
        res.data.campaign = data.campaign;
            this.tempStorage.setItem(context.srfsessionkey+'_campaigncampaigns',JSON.stringify(res.data.campaigncampaigns));
            this.tempStorage.setItem(context.srfsessionkey+'_leads',JSON.stringify(res.data.leads));
            this.tempStorage.setItem(context.srfsessionkey+'_campaignlists',JSON.stringify(res.data.campaignlists));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof CampaignServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/campaigns/${context.campaign}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof CampaignServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let campaigncampaignsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_campaigncampaigns'),'undefined')){
            campaigncampaignsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_campaigncampaigns') as any);
            if(campaigncampaignsData && campaigncampaignsData.length && campaigncampaignsData.length > 0){
                campaigncampaignsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.relationshipsid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.campaigncampaigns = campaigncampaignsData;
        let leadsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_leads'),'undefined')){
            leadsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_leads') as any);
            if(leadsData && leadsData.length && leadsData.length > 0){
                leadsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.leadid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.leads = leadsData;
        let campaignlistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_campaignlists'),'undefined')){
            campaignlistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_campaignlists') as any);
            if(campaignlistsData && campaignlistsData.length && campaignlistsData.length > 0){
                campaignlistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.relationshipsid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.campaignlists = campaignlistsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/campaigns/${context.campaign}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_campaigncampaigns',JSON.stringify(res.data.campaigncampaigns));
            this.tempStorage.setItem(context.srfsessionkey+'_leads',JSON.stringify(res.data.leads));
            this.tempStorage.setItem(context.srfsessionkey+'_campaignlists',JSON.stringify(res.data.campaignlists));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof CampaignServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/campaigns/fetchdefault`,tempData,isloading);
    }
}