import { Subject } from 'rxjs';
import { DashboardViewBase } from '@/studio-core';
import SalesOrderService from '@/service/sales-order/sales-order-service';
import PortalViewEngine from '@engine/view/portal-view-engine';

/**
 * 订单数据看板视图视图基类
 *
 * @export
 * @class SalesOrderSummaryViewBase
 * @extends {DashboardViewBase}
 */
export class SalesOrderSummaryViewBase extends DashboardViewBase {

    /**
     * 实体服务对象
     *
     * @type {SalesOrderService}
     * @memberof SalesOrderSummaryViewBase
     */
    protected appEntityService: SalesOrderService = new SalesOrderService;


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof SalesOrderSummaryViewBase
     */    
    protected counterServiceArray: Array<any> = [];

	/**
	 * 自定义视图导航上下文集合
	 *
     * @protected
	 * @type {*}
	 * @memberof SalesOrderSummaryViewBase
	 */
    protected customViewNavContexts: any = {
        'REGARDINGOBJECTID': { isRawValue: false, value: 'salesorder' },
        'REGARDINGOBJECTTYPECODE': { isRawValue: true, value: 'SALESORDER' }
    };

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof SalesOrderSummaryViewBase
     */
    protected model: any = {
        srfCaption: 'entities.salesorder.views.summaryview.caption',
        srfTitle: 'entities.salesorder.views.summaryview.title',
        srfSubTitle: 'entities.salesorder.views.summaryview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof SalesOrderSummaryViewBase
     */
    protected containerModel: any = {
        view_dashboard: { name: 'dashboard', type: 'DASHBOARD' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '95a02c7480abd6ddb76e14dc079f7508';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof SalesOrderSummaryViewBase
     */
    public engine: PortalViewEngine = new PortalViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof SalesOrderSummaryViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            dashboard: this.$refs.dashboard,
            keyPSDEField: 'salesorder',
            majorPSDEField: 'salesordername',
            isLoadDefault: true,
        });
    }

    /**
     * dashboard 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof SalesOrderSummaryViewBase
     */
    public dashboard_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('dashboard', 'load', $event);
    }


}