import { Subject } from 'rxjs';
import { DashboardViewBase } from '@/studio-core';
import InvoiceService from '@/service/invoice/invoice-service';
import PortalViewEngine from '@engine/view/portal-view-engine';

/**
 * 发票数据看板视图视图基类
 *
 * @export
 * @class InvoiceSummaryViewBase
 * @extends {DashboardViewBase}
 */
export class InvoiceSummaryViewBase extends DashboardViewBase {

    /**
     * 实体服务对象
     *
     * @type {InvoiceService}
     * @memberof InvoiceSummaryViewBase
     */
    protected appEntityService: InvoiceService = new InvoiceService;


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof InvoiceSummaryViewBase
     */    
    protected counterServiceArray: Array<any> = [];

	/**
	 * 自定义视图导航上下文集合
	 *
     * @protected
	 * @type {*}
	 * @memberof InvoiceSummaryViewBase
	 */
    protected customViewNavContexts: any = {
        'REGARDINGOBJECTID': { isRawValue: false, value: 'invoice' },
        'REGARDINGOBJECTTYPECODE': { isRawValue: true, value: 'INVOICE' }
    };

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof InvoiceSummaryViewBase
     */
    protected model: any = {
        srfCaption: 'entities.invoice.views.summaryview.caption',
        srfTitle: 'entities.invoice.views.summaryview.title',
        srfSubTitle: 'entities.invoice.views.summaryview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof InvoiceSummaryViewBase
     */
    protected containerModel: any = {
        view_dashboard: { name: 'dashboard', type: 'DASHBOARD' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '77ef5d53fe0cadbe03c9d2f9d25c804b';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof InvoiceSummaryViewBase
     */
    public engine: PortalViewEngine = new PortalViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof InvoiceSummaryViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            dashboard: this.$refs.dashboard,
            keyPSDEField: 'invoice',
            majorPSDEField: 'invoicename',
            isLoadDefault: true,
        });
    }

    /**
     * dashboard 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof InvoiceSummaryViewBase
     */
    public dashboard_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('dashboard', 'load', $event);
    }


}