import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import CampaignService from '@/service/campaign/campaign-service';
import Info_ManagerService from './info-manager-form-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {Info_ManagerEditFormBase}
 */
export class Info_ManagerEditFormBase extends EditFormControlBase {

    /**
     * 建构部件服务对象
     *
     * @type {Info_ManagerService}
     * @memberof Info_ManagerEditFormBase
     */
    public service: Info_ManagerService = new Info_ManagerService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {CampaignService}
     * @memberof Info_ManagerEditFormBase
     */
    public appEntityService: CampaignService = new CampaignService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof Info_ManagerEditFormBase
     */
    protected appDeName: string = 'campaign';

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof Info_ManagerEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        budgetedcost: null,
        othercost: null,
        totalactualcost: null,
        owneridyominame: null,
        campaignid: null,
        campaign:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof Info_ManagerEditFormBase
     */
    public rules: any = {
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof Info_ManagerEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '管理信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', langbase: 'entities.campaign.info_manager_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '市场活动', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        srfmajortext: new FormItemModel({ caption: '活动名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        budgetedcost: new FormItemModel({ caption: '预算分配', detailType: 'FORMITEM', name: 'budgetedcost', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        othercost: new FormItemModel({ caption: '其他费用', detailType: 'FORMITEM', name: 'othercost', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        totalactualcost: new FormItemModel({ caption: '市场活动总费用', detailType: 'FORMITEM', name: 'totalactualcost', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        owneridyominame: new FormItemModel({ caption: '负责人', detailType: 'FORMITEM', name: 'owneridyominame', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        campaignid: new FormItemModel({ caption: '市场活动', detailType: 'FORMITEM', name: 'campaignid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

    };
}