/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'transactioncurrencyid',
          prop: 'transactioncurrencyid',
          dataType: 'PICKUP',
        },
        {
          name: 'slaid',
          prop: 'slaid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'salesordername',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'salesorderid',
          dataType: 'GUID',
        },
        {
          name: 'srfdataaccaction',
          prop: 'salesorderid',
          dataType: 'GUID',
        },
        {
          name: 'quoteid',
          prop: 'quoteid',
          dataType: 'PICKUP',
        },
        {
          name: 'customerid',
          prop: 'customerid',
          dataType: 'TEXT',
        },
        {
          name: 'opportunityid',
          prop: 'opportunityid',
          dataType: 'PICKUP',
        },
        {
          name: 'campaignid',
          prop: 'campaignid',
          dataType: 'PICKUP',
        },
        {
          name: 'statuscode',
          prop: 'statuscode',
          dataType: 'NSCODELIST',
        },
        {
          name: 'pricelevelid',
          prop: 'pricelevelid',
          dataType: 'PICKUP',
        },
        {
          name: 'salesordername',
          prop: 'salesordername',
          dataType: 'TEXT',
        },
        {
          name: 'totalamount',
          prop: 'totalamount',
          dataType: 'BIGDECIMAL',
        },
        {
          name: 'salesorder',
          prop: 'salesorderid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}