import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, MainControlBase } from '@/studio-core';
import AccountService from '@/service/account/account-service';
import GradationService from './gradation-treegridex-service';
import AccountUIService from '@/uiservice/account/account-ui-service';


/**
 * treegridex部件基类
 *
 * @export
 * @class MainControlBase
 * @extends {GradationTreegridexBase}
 */
export class GradationTreegridexBase extends MainControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof GradationTreegridexBase
     */
    protected controlType: string = 'TREEGRIDEX';

    /**
     * 建构部件服务对象
     *
     * @type {GradationService}
     * @memberof GradationTreegridexBase
     */
    public service: GradationService = new GradationService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {AccountService}
     * @memberof GradationTreegridexBase
     */
    public appEntityService: AccountService = new AccountService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof GradationTreegridexBase
     */
    protected appDeName: string = 'account';

    /**
     * 显示处理提示
     *
     * @type {boolean}
     * @memberof Gradation
     */
    @Prop({ default: true }) public showBusyIndicator?: boolean;

    /**
     * 部件行为--load
     *
     * @type {string}
     * @memberof Gradation
     */
    @Prop() public loadAction!: string;

    /**
     * 是否单选
     *
     * @type {boolean}
     * @memberof Gradation
     */
    @Prop({ default: true }) public isSingleSelect!: boolean;

    /**
     * 部件样式名
     *
     * @public
     * @type {any[]}
     * @memberof Gradation
     */
    public controlClass: string = "treegridex";

    /**
     * 数据集合
     *
     * @public
     * @type {any[]}
     * @memberof Gradation
     */
    public items: any[] = [];

    /**
     * 默认展开节点集合
     *
     * @memberof Gradation
     */
    public defExpands: any = [];

    /**
     * 行节点下标
     *
     * @memberof Gradation
     */
    public itemNum: any = {};

    /**
     * 计数下标
     *
     * @memberof Gradation
     */
    public num: number = 0;

    /**
     * 获取列属性值
     *
     * @public
     * @memberof Gradation
     */
    public getColumnValue(task: any, field: string) {
        if(Object.is(task.id.split(';')[0], 'ROOT')) {
            return task[field];
        }
        if(Object.is(task.id.split(';')[0], 'RootAccount')) {
            return task[field];
        }
        if(Object.is(task.id.split(';')[0], 'ChildAccount')) {
            return task[field];
        }
    }

    /**
     * 获取代码项
     *
     * @public
     * @memberof Gradation
     */
    public getCodeListItem(codelist: any, val: any) {
        for(let i = 0; i < codelist.items.length; i++) {
            if(Object.is(codelist.items[i].value, val)) {
                return codelist.items[i].text;
            }
        }
        return codelist.emptytext;
    }

    /**
     * 搜索获取日程事件
     *
     * @param {*} $event 日期信息
     * @memberof GradationBase
     */
    public load(task: any = {}, resolve?: any) {
        const params: any = {
            srfnodeid: task && task.id ? task.id : "#",
            srfnodefilter: ''
        };
        let tempViewParams:any = JSON.parse(JSON.stringify(this.viewparams));
        let curNode:any = {}; 
        this.$util.deepObjectMerge(curNode, task);
        let tempContext:any = this.computecurNodeContext(curNode);
        if(curNode && curNode.srfparentdename) {
            Object.assign(tempContext,{ srfparentdename: curNode.srfparentdename });
            Object.assign(tempViewParams,{ srfparentdename: curNode.srfparentdename });
        }
        if(curNode && curNode.srfparentkey) {
            Object.assign(tempContext,{ srfparentkey: curNode.srfparentkey });
            Object.assign(tempViewParams,{ srfparentkey: curNode.srfparentkey });
        }
        Object.assign(params,{viewparams:tempViewParams});
        this.service.getNodes(tempContext,params).then((response: any) => {
            if (!response || response.status !== 200) {
                this.$Notice.error({ title: (this.$t('app.commonWords.wrong') as string), desc: response.info });
                return;
            }
            response.data.forEach((item: any) => {
                this.itemNum[item.id] = this.num++;
                if(!item.collapsed) {
                    this.defExpands.push(item);
                }
            })
            if(resolve && resolve instanceof Function) {
                resolve(response.data);
            } else {
                this.items = [...response.data];
            }
            this.$nextTick(() => {
                this.expandDefNode();
            })
            this.$emit("load", this.items);
        }).catch((response: any) => {
            if (response && response.status === 401) {
                return;
            }
            this.$Notice.error({ title: (this.$t('app.commonWords.wrong') as string), desc: response.info });
        });
    }

    /**
     * 加载节点
     *
     * @memberof TreeTable
     */
    public loadTreeNode(tree: any, treeNode: any, resolve: any) {
        this.load(tree, resolve);
    }

    /**
     * 计算当前节点的上下文
     *
     * @param {*} curNode 当前节点
     * @memberof Gradation
     */
    public computecurNodeContext(curNode:any){
        let tempContext:any = {};
        if(curNode && curNode.data && curNode.data.srfappctx){
            tempContext = JSON.parse(JSON.stringify(curNode.data.srfappctx));
        }else{
            tempContext = JSON.parse(JSON.stringify(this.context));
        }
        return tempContext;
    }

    /**
     * 节点展开
     *
     * @param {*} item 当前节点
     * @memberof Gradation
     */
    public itemExpand(item: any) {

    }

    /**
     * 刷新
     *
     * @memberof Gradation
     */
    public refresh() {
        this.load();
    }



    /**
     * 选中的数据
     *
     * @returns {any[]}
     * @memberof Gradation
     */
    public selections: any[] = [];

    /**
     * 获取多项数据
     *
     * @returns {any[]}
     * @memberof Gradation
     */
    public getDatas(): any[] {
        return this.selections;
    }

    /**
     * 获取单项树
     *
     * @returns {*}
     * @memberof Gradation
     */
    public getData(): any {
        return null;
    }
             
    /**
     * vue 生命周期
     *
     * @returns
     * @memberof Gradation
     */
    public created() {
        this.load();
    }

    /**
     * 设置行Class
     *
     * @returns
     * @memberof Gradation
     */
    public setRowClass({row, rowIndex}: {row: any, rowIndex: number}) {
        return 'treegrid' + this.itemNum[row.id];
    }

    /**
     * 展开默认节点
     *
     * @returns
     * @memberof Gradation
     */
    public expandDefNode() {
        if(this.defExpands.length > 0) {
            let item: any = this.defExpands[0];
            this.defExpands.splice(0, 1);
            let trs: any = this.$el.getElementsByClassName('treegrid' + this.itemNum[item.id]);
            if(trs) {
                let icons: any = trs[0].getElementsByClassName('el-table__expand-icon');
                icons[0].click();
            }
        }
    }

    /**
     * 选中变化
     *
     * @returns
     * @memberof Gradation
     */
    public select($event: any) {
        if (!$event) {
            return;
        }
        this.selections = [JSON.parse(JSON.stringify($event))];
        this.$emit('selectionchange', this.selections);
    }

}