import AuthService from '../auth-service';

/**
 * 连接权限服务对象基类
 *
 * @export
 * @class ConnectionAuthServiceBase
 * @extends {AuthService}
 */
export default class ConnectionAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  ConnectionAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ConnectionAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof ConnectionAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}