import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import ProductAssociationService from '@/service/product-association/product-association-service';
import MainService from './main-form-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {MainEditFormBase}
 */
export class MainEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainEditFormBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {ProductAssociationService}
     * @memberof MainEditFormBase
     */
    public appEntityService: ProductAssociationService = new ProductAssociationService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainEditFormBase
     */
    protected appDeName: string = 'productassociation';

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        productid: null,
        associatedproductname: null,
        quantity: null,
        uomname: null,
        associatedproduct: null,
        productassociationid: null,
        uomid: null,
        productassociation:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public rules: any = {
        quantity: [
            { required: true, type: 'number', message: '数量 值不能为空', trigger: 'change' },
            { required: true, type: 'number', message: '数量 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof MainEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: 'productassociation基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', langbase: 'entities.productassociation.main_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '产品关联 ID', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        srfmajortext: new FormItemModel({ caption: '产品名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        productid: new FormItemModel({ caption: '产品', detailType: 'FORMITEM', name: 'productid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        associatedproductname: new FormItemModel({ caption: '关联的产品', detailType: 'FORMITEM', name: 'associatedproductname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        quantity: new FormItemModel({ caption: '数量', detailType: 'FORMITEM', name: 'quantity', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        uomname: new FormItemModel({ caption: '计量单位', detailType: 'FORMITEM', name: 'uomname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        associatedproduct: new FormItemModel({ caption: '关联的产品', detailType: 'FORMITEM', name: 'associatedproduct', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        productassociationid: new FormItemModel({ caption: '产品关联 ID', detailType: 'FORMITEM', name: 'productassociationid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        uomid: new FormItemModel({ caption: '计价单位', detailType: 'FORMITEM', name: 'uomid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

    };
}