import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControllerBase } from '@/studio-core';
import ListContactService from '@/service/list-contact/list-contact-service';
import InnerService from './inner-grid-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControllerBase
 * @extends {InnerGridBase}
 */
export class InnerGridBase extends GridControllerBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof InnerGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {InnerService}
     * @memberof InnerGridBase
     */
    public service: InnerService = new InnerService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {ListContactService}
     * @memberof InnerGridBase
     */
    public appEntityService: ListContactService = new ListContactService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof InnerGridBase
     */
    protected appDeName: string = 'listcontact';

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof GridControllerBase
     */
    protected localStorageTag: string = 'listcontact_inner_grid';

    /**
     * 是否支持分页
     *
     * @type {boolean}
     * @memberof InnerGridBase
     */
    public isEnablePagingBar: boolean = false;

    /**
     * 分页条数
     *
     * @type {number}
     * @memberof InnerGridBase
     */
    public limit: number = 50;

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof InnerGridBase
     */
    public allColumns: any[] = [
        {
            name: 'entity2name',
            label: '联系人',
            langtag: 'entities.listcontact.inner_grid.columns.entity2name',
            show: true,
            util: 'PX'
        },
        {
            name: 'emailaddress1',
            label: '电子邮件',
            langtag: 'entities.listcontact.inner_grid.columns.emailaddress1',
            show: true,
            util: 'PX'
        },
        {
            name: 'parentcustomerid',
            label: '公司名称',
            langtag: 'entities.listcontact.inner_grid.columns.parentcustomerid',
            show: true,
            util: 'PX'
        },
        {
            name: 'telephone1',
            label: '商务电话',
            langtag: 'entities.listcontact.inner_grid.columns.telephone1',
            show: true,
            util: 'PX'
        },
        {
            name: 'statecode',
            label: '状态',
            langtag: 'entities.listcontact.inner_grid.columns.statecode',
            show: true,
            util: 'PX'
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof InnerGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof InnerGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '关系标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '关系标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof InnerBase
     */
    public hasRowEdit: any = {
        'entity2name':false,
        'emailaddress1':false,
        'parentcustomerid':false,
        'telephone1':false,
        'statecode':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof InnerBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof InnerGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'statecode',
                srfkey: 'Contact__StateCode',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }

}