/**
 * SalLitCompGrid 部件模型
 *
 * @export
 * @class SalLitCompGridModel
 */
export default class SalLitCompGridModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof SalLitCompGridGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof SalLitCompGridGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'entity2id',
          prop: 'entity2id',
          dataType: 'PICKUP',
        },
        {
          name: 'entityid',
          prop: 'entityid',
          dataType: 'PICKUP',
        },
        {
          name: 'entityname',
          prop: 'entityname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'relationshipsname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'relationshipsid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'relationshipsid',
          dataType: 'GUID',
        },
        {
          name: 'entity2name',
          prop: 'entity2name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'competitorsalesliterature',
          prop: 'relationshipsid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}