import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import CompetitorSalesLiteratureService from '@/service/competitor-sales-literature/competitor-sales-literature-service';
import SalLitCompService from './sal-lit-comp-form-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {SalLitCompEditFormBase}
 */
export class SalLitCompEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof SalLitCompEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {SalLitCompService}
     * @memberof SalLitCompEditFormBase
     */
    public service: SalLitCompService = new SalLitCompService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {CompetitorSalesLiteratureService}
     * @memberof SalLitCompEditFormBase
     */
    public appEntityService: CompetitorSalesLiteratureService = new CompetitorSalesLiteratureService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof SalLitCompEditFormBase
     */
    protected appDeName: string = 'competitorsalesliterature';

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof SalLitCompEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        entity2id: null,
        entityname: null,
        relationshipsid: null,
        entityid: null,
        competitorsalesliterature:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof SalLitCompEditFormBase
     */
    public rules: any = {
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof SalLitCompEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '竞争对手宣传资料基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', langbase: 'entities.competitorsalesliterature.sallitcomp_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '关系标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '关系名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        entity2id: new FormItemModel({ caption: '销售宣传资料', detailType: 'FORMITEM', name: 'entity2id', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        entityname: new FormItemModel({ caption: '竞争对手', detailType: 'FORMITEM', name: 'entityname', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        relationshipsid: new FormItemModel({ caption: '关系标识', detailType: 'FORMITEM', name: 'relationshipsid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        entityid: new FormItemModel({ caption: '竞争对手', detailType: 'FORMITEM', name: 'entityid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

    };
}