import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import CampaignService from '@/service/campaign/campaign-service';
import Info_ScheduleService from './info-schedule-form-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {Info_ScheduleEditFormBase}
 */
export class Info_ScheduleEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof Info_ScheduleEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {Info_ScheduleService}
     * @memberof Info_ScheduleEditFormBase
     */
    public service: Info_ScheduleService = new Info_ScheduleService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {CampaignService}
     * @memberof Info_ScheduleEditFormBase
     */
    public appEntityService: CampaignService = new CampaignService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof Info_ScheduleEditFormBase
     */
    protected appDeName: string = 'campaign';

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof Info_ScheduleEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        proposedstart: null,
        proposedend: null,
        actualstart: null,
        actualend: null,
        campaignid: null,
        campaign:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof Info_ScheduleEditFormBase
     */
    public rules: any = {
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof Info_ScheduleEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '日程安排', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', langbase: 'entities.campaign.info_schedule_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '市场活动', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

        srfmajortext: new FormItemModel({ caption: '活动名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        proposedstart: new FormItemModel({ caption: '拟定日期', detailType: 'FORMITEM', name: 'proposedstart', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        proposedend: new FormItemModel({ caption: '拟定结束日期', detailType: 'FORMITEM', name: 'proposedend', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        actualstart: new FormItemModel({ caption: '实际开始日期', detailType: 'FORMITEM', name: 'actualstart', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        actualend: new FormItemModel({ caption: '实际结束日期', detailType: 'FORMITEM', name: 'actualend', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        campaignid: new FormItemModel({ caption: '市场活动', detailType: 'FORMITEM', name: 'campaignid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 1 }),

    };
}