/**
 * Central 部件模型
 *
 * @export
 * @class CentralModel
 */
export default class CentralModel {

    /**
     * 菜单项集合
     *
     * @private
     * @type {any[]}
     * @memberof CentralModel
     */
    private items: any[] = [
                {
        	id: 'd15157cb8d73af87f553f85887fdcbf8',
        	name: 'user_menus',
        	text: '用户菜单',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '用户菜单',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        	items: [
                		        {
                	id: '76d07a396b5ff6dfe8156b969ef9fb6a',
                	name: 'menuitem3',
                	text: '设置',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '设置',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-newspaper-o',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                }
                ,
                		        {
                	id: '150d5d0c57788f79b3a22edbea800198',
                	name: 'menuitem4',
                	text: '注销',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '注销',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-level-down',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                }
                ,
        	],
        }
        ,
                {
        	id: 'e5dcbd32f6a4050109f54d97de44b715',
        	name: 'top_menus',
        	text: '顶部菜单',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '顶部菜单',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
                {
        	id: '4aea3655e93af303beba942116b04a31',
        	name: 'left_exp',
        	text: '左侧菜单',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '左侧菜单',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        	items: [
                		        {
                	id: 'bc7e54efebeacbb9d7de317c5b049c33',
                	name: 'menuitem17',
                	text: '主页',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '主页',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-home',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                }
                ,
                		        {
                	id: '1a17fc650d716d88e6a694b4ef927d08',
                	name: 'menuitem18',
                	text: '最近',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '最近',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-clock-o',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                }
                ,
                		        {
                	id: '397f15992c5f2d89eb45c2db2a30b61b',
                	name: 'menuitem19',
                	text: '固定',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '固定',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-thumb-tack',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                }
                ,
                		        {
                	id: 'b6776d6c3b5b271b7bb8b34238fe989c',
                	name: 'menuitem16',
                	text: '我的工作',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '我的工作',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-legal',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: '1f0a683ed841fe47b32eea5b3f90dab2',
                        	name: 'menuitem1',
                        	text: '仪表盘',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '仪表盘',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: true,
                        	iconcls: 'fa fa-line-chart',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto16',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'centeral-portal',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '35fdbf18942b76c215e68e7563687801',
                        	name: 'menuitem2',
                        	text: '活动',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '活动',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-paper-plane',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto9',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'activity-pointer-grid-view',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
                		        {
                	id: 'b45e8d47cc61dc640b358b367ae5e0f8',
                	name: 'menuitem20',
                	text: '客户',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '客户',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-sitemap',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: 'b96d9b68c2d32e8433bc1a6544acec35',
                        	name: 'menuitem5',
                        	text: '客户',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '客户',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-users',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_4',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'account-status-tab-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '881cab98a5418e8ff6448f06bf437646',
                        	name: 'menuitem7',
                        	text: '联系人',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '联系人',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-user',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto7',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'contact-tab-exp-view',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
                		        {
                	id: 'b3053fbb709cb27d1f51ce6a905a5c8c',
                	name: 'menuitem21',
                	text: '销售',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '销售',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-credit-card',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: 'dc4e1933767eadfd04742c451d0db341',
                        	name: 'menuitem8',
                        	text: '潜在客户',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '潜在客户',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-phone',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto14',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'lead-status-tab-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '5c49ce38bd48f0679e6b8dd88bade670',
                        	name: 'menuitem9',
                        	text: '商机',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '商机',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-envelope-o',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto10',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'opportunity-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '1bdda8185850a0ffa37bec44707b2047',
                        	name: 'menuitem10',
                        	text: '竞争对手',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '竞争对手',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-user-secret',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto12',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'competitor-grid-view',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
                		        {
                	id: '7acd98cbdc56f35c7bbd79c5d35826b2',
                	name: 'menuitem22',
                	text: '宣传资料',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '宣传资料',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-book',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: '3902e57b8693cb2bf8e518bb01984ed6',
                        	name: 'menuitem11',
                        	text: '报价单',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '报价单',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-file-o',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto5',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'quote-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '8582688e1e8d8bca7d5bf880366ba945',
                        	name: 'menuitem12',
                        	text: '订单',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '订单',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-file-text-o',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto3',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'sales-order-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: 'c74b2398822a0ebfe19d7df699a40088',
                        	name: 'menuitem13',
                        	text: '发票',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '发票',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-newspaper-o',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto6',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'invoice-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '3830c93006e965fa62c660c2c7a8f9d6',
                        	name: 'menuitem6',
                        	text: '产品',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '产品',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-cube',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto11',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'product-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '299fff0321c1099c0b3879c034987a38',
                        	name: 'menuitem14',
                        	text: '销售宣传资料',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '销售宣传资料',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-book',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto2',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'sales-literature-grid-view',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
                		        {
                	id: '91125f38268e87fdf3f2a532d5cab0b3',
                	name: 'menuitem23',
                	text: '市场营销',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '市场营销',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-shopping-cart',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: '05EC84AA-5E79-47BD-B4B3-4DDAC4971BC1',
                        	name: 'menuitem30',
                        	text: '市场活动',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '市场活动',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-lastfm',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto15',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'campaign-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '9d8a95a162adb059740db3cd304dfd3b',
                        	name: 'menuitem15',
                        	text: '市场营销列表',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '市场营销列表',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-list',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto1',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'ibiz-list-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '5bcda52e467d81ca235e117c389c2f1e',
                        	name: 'menuitem29',
                        	text: '快速市场活动',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '快速市场活动',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-volume-off',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
                		        {
                	id: 'd122b1507a020737aad8946695937ce8',
                	name: 'menuitem24',
                	text: '绩效',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '绩效',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-slack',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: '7865cc7821cd0417f5260b765479666c',
                        	name: 'menuitem25',
                        	text: '目标',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '目标',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-flag-checkered',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto13',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'goal-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: 'C332BAD9-C1DC-44D2-A872-CD400C39C69F',
                        	name: 'menuitem31',
                        	text: '目标度量',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '目标度量',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-line-chart',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_3',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'metric-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '9014c07bd1da4beac8c7fc4f34c54eec',
                        	name: 'menuitem26',
                        	text: '预测',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '预测',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-dot-circle-o',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '9865490D-A150-450A-9695-3F4610E9A5BE',
                        	name: 'menuitem33',
                        	text: '目标分页',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '目标分页',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: '',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '_2',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'goal-state-tab-view',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
                		        {
                	id: '359e8fadad16fed7538b6017cfe73c38',
                	name: 'menuitem27',
                	text: '服务',
                	type: 'MENUITEM',
                	counterid: '',
                	tooltip: '服务',
                	expanded: false,
                	separator: false,
                	hidden: false,
                	hidesidebar: false,
                	opendefault: false,
                	iconcls: 'fa fa-skyatlas',
                	icon: '',
                	textcls: '',
                	appfunctag: '',
                	resourcetag: '',
                	items: [
                        		        {
                        	id: '528dbb5c73152a802042ab2376a6fb31',
                        	name: 'menuitem28',
                        	text: '服务案例',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '服务案例',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-wrench',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: 'Auto8',
                        	appfuncyype: 'APPVIEW',
                        	viewname: 'incident-grid-view',
                        	resourcetag: '',
                        }
                        ,
                        		        {
                        	id: '4A58B77A-F97D-4B19-A757-75C0A110FB78',
                        	name: 'menuitem32',
                        	text: '知识文章',
                        	type: 'MENUITEM',
                        	counterid: '',
                        	tooltip: '知识文章',
                        	expanded: false,
                        	separator: false,
                        	hidden: false,
                        	hidesidebar: false,
                        	opendefault: false,
                        	iconcls: 'fa fa-files-o',
                        	icon: '',
                        	textcls: '',
                        	appfunctag: '',
                        	resourcetag: '',
                        }
                        ,
                	],
                }
                ,
        	],
        }
        ,
                {
        	id: 'a204fcf70ab1a00c493e7128f2cfcd81',
        	name: 'bottom_exp',
        	text: '底部内容',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '底部内容',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
                {
        	id: '1c23002189e603110b9858de93d5a01d',
        	name: 'footer_left',
        	text: '底部左侧',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '底部左侧',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
                {
        	id: '28eaf24dc5f9fec02d69fc36e74b1713',
        	name: 'footer_center',
        	text: '底部中间',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '底部中间',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
                {
        	id: '908c555e923dbc2137a9998e1065a700',
        	name: 'footer_right',
        	text: '底部右侧',
        	type: 'MENUITEM',
        	counterid: '',
        	tooltip: '底部右侧',
        	expanded: false,
        	separator: false,
        	hidden: false,
        	hidesidebar: false,
        	opendefault: false,
        	iconcls: '',
        	icon: '',
        	textcls: '',
        	appfunctag: '',
        	resourcetag: '',
        }
        ,
    ];

	/**
	 * 应用功能集合
	 *
	 * @private
	 * @type {any[]}
	 * @memberof CentralModel
	 */
	private funcs: any[] = [
        {
            appfunctag: 'Auto8',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'incidentgridview',
            deResParameters: [],
            routepath: '/central/:central?/incidents/:incident?/gridview/:gridview?',
            parameters: [
                { pathName: 'incidents', parameterName: 'incident' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto13',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'goalgridview',
            deResParameters: [],
            routepath: '/central/:central?/goals/:goal?/gridview/:gridview?',
            parameters: [
                { pathName: 'goals', parameterName: 'goal' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto9',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'activitypointergridview',
            deResParameters: [],
            routepath: '/central/:central?/activitypointers/:activitypointer?/gridview/:gridview?',
            parameters: [
                { pathName: 'activitypointers', parameterName: 'activitypointer' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto12',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'competitorgridview',
            deResParameters: [],
            routepath: '/central/:central?/competitors/:competitor?/gridview/:gridview?',
            parameters: [
                { pathName: 'competitors', parameterName: 'competitor' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto2',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'salesliteraturegridview',
            deResParameters: [],
            routepath: '/central/:central?/salesliteratures/:salesliterature?/gridview/:gridview?',
            parameters: [
                { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto3',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'salesordergridview',
            deResParameters: [],
            routepath: '/central/:central?/salesorders/:salesorder?/gridview/:gridview?',
            parameters: [
                { pathName: 'salesorders', parameterName: 'salesorder' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto6',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'invoicegridview',
            deResParameters: [],
            routepath: '/central/:central?/invoices/:invoice?/gridview/:gridview?',
            parameters: [
                { pathName: 'invoices', parameterName: 'invoice' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_3',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'metricgridview',
            deResParameters: [],
            routepath: '/central/:central?/metrics/:metric?/gridview/:gridview?',
            parameters: [
                { pathName: 'metrics', parameterName: 'metric' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto15',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'campaigngridview',
            deResParameters: [],
            routepath: '/central/:central?/campaigns/:campaign?/gridview/:gridview?',
            parameters: [
                { pathName: 'campaigns', parameterName: 'campaign' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto11',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'productgridview',
            deResParameters: [],
            routepath: '/central/:central?/products/:product?/gridview/:gridview?',
            parameters: [
                { pathName: 'products', parameterName: 'product' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_2',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'goalstatetabview',
            deResParameters: [],
            routepath: '/central/:central?/goals/:goal?/statetabview/:statetabview?',
            parameters: [
                { pathName: 'goals', parameterName: 'goal' },
                { pathName: 'statetabview', parameterName: 'statetabview' },
            ],
        },
        {
            appfunctag: 'Auto14',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'leadstatustabview',
            deResParameters: [],
            routepath: '/central/:central?/leads/:lead?/statustabview/:statustabview?',
            parameters: [
                { pathName: 'leads', parameterName: 'lead' },
                { pathName: 'statustabview', parameterName: 'statustabview' },
            ],
        },
        {
            appfunctag: 'Auto10',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'opportunitygridview',
            deResParameters: [],
            routepath: '/central/:central?/opportunities/:opportunity?/gridview/:gridview?',
            parameters: [
                { pathName: 'opportunities', parameterName: 'opportunity' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto16',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'centeralportal',
            deResParameters: [],
            routepath: '/central/:central?/centeralportal/:centeralportal?',
            parameters: [
                { pathName: 'centeralportal', parameterName: 'centeralportal' },
            ],
        },
        {
            appfunctag: 'Auto1',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'ibizlistgridview',
            deResParameters: [],
            routepath: '/central/:central?/ibizlists/:ibizlist?/gridview/:gridview?',
            parameters: [
                { pathName: 'ibizlists', parameterName: 'ibizlist' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto7',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'contacttabexpview',
            deResParameters: [],
            routepath: '/central/:central?/contacts/:contact?/tabexpview/:tabexpview?',
            parameters: [
                { pathName: 'contacts', parameterName: 'contact' },
                { pathName: 'tabexpview', parameterName: 'tabexpview' },
            ],
        },
        {
            appfunctag: '_4',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'accountstatustabview',
            deResParameters: [],
            routepath: '/central/:central?/accounts/:account?/statustabview/:statustabview?',
            parameters: [
                { pathName: 'accounts', parameterName: 'account' },
                { pathName: 'statustabview', parameterName: 'statustabview' },
            ],
        },
        {
            appfunctag: 'Auto5',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'quotegridview',
            deResParameters: [],
            routepath: '/central/:central?/quotes/:quote?/gridview/:gridview?',
            parameters: [
                { pathName: 'quotes', parameterName: 'quote' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
	];

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof CentralModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

	/**
	 * 根据名称获取菜单组
	 *
	 * @param {string} name
	 * @returns {*}
	 * @memberof CentralModel
	 */
	public getMenuGroup(name: string): any {
		return this.items.find((item: any) => Object.is(item.name, name));
	}

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof CentralModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}