import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import ActivityPointerService from '@/service/activity-pointer/activity-pointer-service';
import ByParentKeyModel from './by-parent-key-list-model';


/**
 * ByParentKey 部件服务对象
 *
 * @export
 * @class ByParentKeyService
 */
export default class ByParentKeyService extends ControlService {

    /**
     * 活动服务对象
     *
     * @type {ActivityPointerService}
     * @memberof ByParentKeyService
     */
    public appEntityService: ActivityPointerService = new ActivityPointerService({ $store: this.getStore() });

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof ByParentKeyService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of ByParentKeyService.
     * 
     * @param {*} [opts={}]
     * @memberof ByParentKeyService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new ByParentKeyModel();
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ByParentKeyService
     */
    @Errorlog
    public search(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data,true);
        return new Promise((resolve: any, reject: any) => {
            const _appEntityService: any = this.appEntityService;
            let result: Promise<any>;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            }else{
                result =_appEntityService.FetchDefault(Context,Data, isloading);
            }
            result.then(async (response) => {
                await this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });      
        });
    }

    /**
     * 删除数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ByParentKeyService
     */
    @Errorlog
    public delete(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data,true);
        return new Promise((resolve: any, reject: any) => {
            const _appEntityService: any = this.appEntityService;
            let result: Promise<any>;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            }else{
                result =_appEntityService.remove(Context,Data , isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });      
        });
    }

}