/**
 * Gradation 部件模型
 *
 * @export
 * @class GradationModel
 */
export default class GradationModel {

	/**
	 * 日历项类型
	 *
	 * @returns {any[]}
	 * @memberof GradationTreegridexMode
	 */
	public itemType: string = "";

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof GradationTreegridexMode
	 */
	public getDataItems(): any[] {
     let dataItems: any = [
          // 前端新增修改标识，新增为"0",修改为"1"或未设值
          {
            name: 'srffrontuf',
            prop: 'srffrontuf',
            dataType: 'TEXT',
          },
          {
            name: 'style',
          },
          {
            name: 'textColor',
          },
          {
            name: 'itemType',
          },
          {
            name: 'parentId'
          },
          {
            name: 'query',
            prop: 'query',
          },
      ];
      switch(this.itemType){
          case "RootAccount":
              dataItems = [...dataItems,
                  {
                    name: 'id',
                    prop: 'accountid'
                  },
                  {
                    name: 'accountname',
                    prop: 'accountname'
                  },
              ];
              break;
          case "ChildAccount":
              dataItems = [...dataItems,
                  {
                    name: 'id',
                    prop: 'accountid'
                  },
                  {
                    name: 'accountname',
                    prop: 'accountname'
                  },
              ];
              break;
      }
      return dataItems;
	}

}