import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import AccountService from '@/service/account/account-service';
import Edit_AddressService from './edit-address-form-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {Edit_AddressEditFormBase}
 */
export class Edit_AddressEditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof Edit_AddressEditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {Edit_AddressService}
     * @memberof Edit_AddressEditFormBase
     */
    public service: Edit_AddressService = new Edit_AddressService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {AccountService}
     * @memberof Edit_AddressEditFormBase
     */
    public appEntityService: AccountService = new AccountService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof Edit_AddressEditFormBase
     */
    protected appDeName: string = 'account';

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof Edit_AddressEditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        address1_addressid: null,
        address1_name: null,
        address1_addresstypecode: null,
        address1_country: null,
        address1_stateorprovince: null,
        address1_city: null,
        address1_county: null,
        accountid: null,
        account:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof Edit_AddressEditFormBase
     */
    public rules: any = {
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof Edit_AddressEditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '客户基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, uiActionGroup: { caption: '', langbase: 'entities.account.edit_address_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 0 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '客户', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '客户名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        address1_addressid: new FormItemModel({ caption: '地址 1: ID', detailType: 'FORMITEM', name: 'address1_addressid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        address1_name: new FormItemModel({ caption: '地址 1: 名称', detailType: 'FORMITEM', name: 'address1_name', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        address1_addresstypecode: new FormItemModel({ caption: '地址 1: 地址类型', detailType: 'FORMITEM', name: 'address1_addresstypecode', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        address1_country: new FormItemModel({ caption: '地址 1: 国家/地区', detailType: 'FORMITEM', name: 'address1_country', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        address1_stateorprovince: new FormItemModel({ caption: '地址 1: 省/市/自治区', detailType: 'FORMITEM', name: 'address1_stateorprovince', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        address1_city: new FormItemModel({ caption: '地址 1: 市/县', detailType: 'FORMITEM', name: 'address1_city', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        address1_county: new FormItemModel({ caption: '地址 1: 县', detailType: 'FORMITEM', name: 'address1_county', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

        accountid: new FormItemModel({ caption: '客户', detailType: 'FORMITEM', name: 'accountid', visible: true, isShowCaption: true, form: this, disabled: false, enableCond: 3 }),

    };
}