/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'websitecode',
          prop: 'websitecode',
          dataType: 'TEXT',
        },
        {
          name: 'memo',
          prop: 'memo',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'srfmajortext',
          prop: 'websitename',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'websiteid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'websiteid',
          dataType: 'GUID',
        },
        {
          name: 'websitename',
          prop: 'websitename',
          dataType: 'TEXT',
        },
        {
          name: 'validflag',
          prop: 'validflag',
          dataType: 'YESNO',
        },
        {
          name: 'website',
          prop: 'websiteid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}