/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'sn',
          prop: 'sn',
          dataType: 'INT',
        },
        {
          name: 'memo',
          prop: 'memo',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'contenttype',
          prop: 'contenttype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'srfmajortext',
          prop: 'websitecontentname',
          dataType: 'TEXT',
        },
        {
          name: 'websitechannelname',
          prop: 'websitechannelname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'srfkey',
          prop: 'websitecontentid',
          dataType: 'GUID',
        },
        {
          name: 'srfdataaccaction',
          prop: 'websitecontentid',
          dataType: 'GUID',
        },
        {
          name: 'validflag',
          prop: 'validflag',
          dataType: 'YESNO',
        },
        {
          name: 'author',
          prop: 'author',
          dataType: 'TEXT',
        },
        {
          name: 'title',
          prop: 'title',
          dataType: 'TEXT',
        },
        {
          name: 'websitechannelid',
          prop: 'websitechannelid',
          dataType: 'PICKUP',
        },
        {
          name: 'websiteid',
          prop: 'websiteid',
          dataType: 'PICKUP',
        },
        {
          name: 'contentcode',
          prop: 'contentcode',
          dataType: 'TEXT',
        },
        {
          name: 'websitename',
          prop: 'websitename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'websitecontent',
          prop: 'websitecontentid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}