import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControllerBase } from '@/studio-core';
import WebSiteContentService from '@/service/web-site-content/web-site-content-service';
import MainService from './main-grid-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControllerBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControllerBase {

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {WebSiteContentService}
     * @memberof MainGridBase
     */
    public appEntityService: WebSiteContentService = new WebSiteContentService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'websitecontent';

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof GridControllerBase
     */
    protected localStorageTag: string = 'websitecontent_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'websitename',
            label: '站点',
            langtag: 'entities.websitecontent.main_grid.columns.websitename',
            show: true,
            util: 'PX'
        },
        {
            name: 'websitechannelname',
            label: '频道',
            langtag: 'entities.websitecontent.main_grid.columns.websitechannelname',
            show: true,
            util: 'PX'
        },
        {
            name: 'sn',
            label: '序号',
            langtag: 'entities.websitecontent.main_grid.columns.sn',
            show: true,
            util: 'PX'
        },
        {
            name: 'contenttype',
            label: '内容类型',
            langtag: 'entities.websitecontent.main_grid.columns.contenttype',
            show: true,
            util: 'PX'
        },
        {
            name: 'title',
            label: '标题',
            langtag: 'entities.websitecontent.main_grid.columns.title',
            show: true,
            util: 'PX'
        },
        {
            name: 'contentcode',
            label: '业务标识',
            langtag: 'entities.websitecontent.main_grid.columns.contentcode',
            show: true,
            util: 'PX'
        },
        {
            name: 'author',
            label: '作者',
            langtag: 'entities.websitecontent.main_grid.columns.author',
            show: true,
            util: 'PX'
        },
        {
            name: 'validflag',
            label: '是否启用',
            langtag: 'entities.websitecontent.main_grid.columns.validflag',
            show: true,
            util: 'PX'
        },
        {
            name: 'memo',
            label: '备注',
            langtag: 'entities.websitecontent.main_grid.columns.memo',
            show: true,
            util: 'STAR'
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '内容标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '内容标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'websitename':false,
        'websitechannelname':false,
        'sn':false,
        'contenttype':false,
        'title':false,
        'contentcode':false,
        'author':false,
        'validflag':false,
        'memo':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
            {
                name: 'contenttype',
                srfkey: 'ContentType',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
            {
                name: 'validflag',
                srfkey: 'YesNo',
                codelistType : 'STATIC',
                renderMode: 'other',
                textSeparator: '、',
                valueSeparator: ',',
            },
        ]);
    }

}