/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'sn',
          prop: 'sn',
          dataType: 'INT',
        },
        {
          name: 'memo',
          prop: 'memo',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'pwebsitechannelname',
          prop: 'pwebsitechannelname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'pwebsitechannelid',
          prop: 'pwebsitechannelid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'websitechannelname',
          dataType: 'TEXT',
        },
        {
          name: 'websitechannelname',
          prop: 'websitechannelname',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'websitechannelid',
          dataType: 'GUID',
        },
        {
          name: 'srfdataaccaction',
          prop: 'websitechannelid',
          dataType: 'GUID',
        },
        {
          name: 'validflag',
          prop: 'validflag',
          dataType: 'YESNO',
        },
        {
          name: 'channeltype',
          prop: 'channeltype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'websiteid',
          prop: 'websiteid',
          dataType: 'PICKUP',
        },
        {
          name: 'channelcode',
          prop: 'channelcode',
          dataType: 'TEXT',
        },
        {
          name: 'websitename',
          prop: 'websitename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'websitechannel',
          prop: 'websitechannelid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}