import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router'
import { AppService } from '@/studio-core/service/app-service/AppService';

Vue.use(Router);

const appService = new AppService();

const router = new Router({
    routes: [
        {
            path: '/central/:central?',
            beforeEnter: (to: any, from: any, next: any) => {
                const routerParamsName = 'central';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    Object.assign(params, qs.parse(to.params[routerParamsName], { delimiter: ';' }));
                }
                const url: string = '/appdata';
                const auth: Promise<any> = AuthGuard.getInstance().authGuard(url, params, router);
                auth.then(() => {
                    next();
                }).catch(() => {
                    next();
                });
                appService.navHistory.indexMeta = {
                    caption: 'app.views.central.title',
                    info:'',
                    viewType: 'APPINDEX',
                    parameters: [
                        { pathName: 'central', parameterName: 'central' },
                    ],
                    requireAuth: true,
                };
            },
            meta: {  
                caption: 'app.views.central.title',
                info:'',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'central', parameterName: 'central' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/base/central/central.vue'),
            children: [
                {
                    path: 'ibizlists/:ibizlist?/stopgridview/:stopgridview?',
                    meta: {
                        caption: 'entities.ibizlist.views.stopgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'stopgridview', parameterName: 'stopgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/ibiz-list-stop-grid-view/ibiz-list-stop-grid-view.vue'),
                },
                {
                    path: 'goals/:goal?/childgoalgridview/:childgoalgridview?',
                    meta: {
                        caption: 'entities.goal.views.childgoalgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'childgoalgridview', parameterName: 'childgoalgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-child-goal-grid-view/goal-child-goal-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/effectivegridview/:effectivegridview?',
                    meta: {
                        caption: 'entities.quote.views.effectivegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'effectivegridview', parameterName: 'effectivegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-effective-grid-view/quote-effective-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/effectivegridview/:effectivegridview?',
                    meta: {
                        caption: 'entities.quote.views.effectivegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'effectivegridview', parameterName: 'effectivegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-effective-grid-view/quote-effective-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/effectivegridview/:effectivegridview?',
                    meta: {
                        caption: 'entities.quote.views.effectivegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'effectivegridview', parameterName: 'effectivegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-effective-grid-view/quote-effective-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/effectivegridview/:effectivegridview?',
                    meta: {
                        caption: 'entities.quote.views.effectivegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'effectivegridview', parameterName: 'effectivegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-effective-grid-view/quote-effective-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/effectivegridview/:effectivegridview?',
                    meta: {
                        caption: 'entities.quote.views.effectivegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'effectivegridview', parameterName: 'effectivegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-effective-grid-view/quote-effective-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/info_invoiceview/:info_invoiceview?',
                    meta: {
                        caption: 'entities.invoice.views.info_invoiceview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'info_invoiceview', parameterName: 'info_invoiceview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-invoice-view/invoice-info-invoice-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/info_invoiceview/:info_invoiceview?',
                    meta: {
                        caption: 'entities.invoice.views.info_invoiceview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'info_invoiceview', parameterName: 'info_invoiceview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-invoice-view/invoice-info-invoice-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/info_invoiceview/:info_invoiceview?',
                    meta: {
                        caption: 'entities.invoice.views.info_invoiceview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'info_invoiceview', parameterName: 'info_invoiceview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-invoice-view/invoice-info-invoice-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/info_invoiceview/:info_invoiceview?',
                    meta: {
                        caption: 'entities.invoice.views.info_invoiceview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'info_invoiceview', parameterName: 'info_invoiceview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-invoice-view/invoice-info-invoice-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/info_invoiceview/:info_invoiceview?',
                    meta: {
                        caption: 'entities.invoice.views.info_invoiceview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'info_invoiceview', parameterName: 'info_invoiceview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-invoice-view/invoice-info-invoice-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/info_invoiceview/:info_invoiceview?',
                    meta: {
                        caption: 'entities.invoice.views.info_invoiceview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'info_invoiceview', parameterName: 'info_invoiceview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-invoice-view/invoice-info-invoice-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/info_invoiceview/:info_invoiceview?',
                    meta: {
                        caption: 'entities.invoice.views.info_invoiceview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'info_invoiceview', parameterName: 'info_invoiceview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-invoice-view/invoice-info-invoice-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.competitor.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-option-view/competitor-option-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.ibizlist.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/ibiz-list-edit-data-panel-view/ibiz-list-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/editview/:editview?',
                    meta: {
                        caption: 'entities.account.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-edit-view/account-edit-view.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/productsalesliteratures/:productsalesliterature?/sallitprogridview/:sallitprogridview?',
                    meta: {
                        caption: 'entities.productsalesliterature.views.sallitprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'productsalesliteratures', parameterName: 'productsalesliterature' },
                            { pathName: 'sallitprogridview', parameterName: 'sallitprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/product-sales-literature-sal-lit-pro-grid-view/product-sales-literature-sal-lit-pro-grid-view.vue'),
                },
                {
                    path: 'productsalesliteratures/:productsalesliterature?/sallitprogridview/:sallitprogridview?',
                    meta: {
                        caption: 'entities.productsalesliterature.views.sallitprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'productsalesliteratures', parameterName: 'productsalesliterature' },
                            { pathName: 'sallitprogridview', parameterName: 'sallitprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/product-sales-literature-sal-lit-pro-grid-view/product-sales-literature-sal-lit-pro-grid-view.vue'),
                },
                {
                    path: 'incidents/:incident?/childincidentgridview/:childincidentgridview?',
                    meta: {
                        caption: 'entities.incident.views.childincidentgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'childincidentgridview', parameterName: 'childincidentgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-child-incident-grid-view/incident-child-incident-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/infoabstract/:infoabstract?',
                    meta: {
                        caption: 'entities.quote.views.infoabstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'infoabstract', parameterName: 'infoabstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-info-abstract/quote-info-abstract.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/infoabstract/:infoabstract?',
                    meta: {
                        caption: 'entities.quote.views.infoabstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'infoabstract', parameterName: 'infoabstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-info-abstract/quote-info-abstract.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/infoabstract/:infoabstract?',
                    meta: {
                        caption: 'entities.quote.views.infoabstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'infoabstract', parameterName: 'infoabstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-info-abstract/quote-info-abstract.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/infoabstract/:infoabstract?',
                    meta: {
                        caption: 'entities.quote.views.infoabstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'infoabstract', parameterName: 'infoabstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-info-abstract/quote-info-abstract.vue'),
                },
                {
                    path: 'quotes/:quote?/infoabstract/:infoabstract?',
                    meta: {
                        caption: 'entities.quote.views.infoabstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'infoabstract', parameterName: 'infoabstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-info-abstract/quote-info-abstract.vue'),
                },
                {
                    path: 'products/:product?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.product.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-pickup-view/product-pickup-view.vue'),
                },
                {
                    path: 'centeralportal/:centeralportal?',
                    meta: {
                        caption: 'app.views.centeralportal.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'centeralportal', parameterName: 'centeralportal' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ungroup/centeral-portal/centeral-portal.vue'),
                },
                {
                    path: 'tasks/:task?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.task.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'tasks', parameterName: 'task' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/task-quick-create/task-quick-create.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.opportunity.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-quick-create/opportunity-quick-create.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.opportunity.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-quick-create/opportunity-quick-create.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.opportunity.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-quick-create/opportunity-quick-create.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.opportunity.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-quick-create/opportunity-quick-create.vue'),
                },
                {
                    path: 'products/:product?/productpricelevels/:productpricelevel?/proprilveditview/:proprilveditview?',
                    meta: {
                        caption: 'entities.productpricelevel.views.proprilveditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'productpricelevels', parameterName: 'productpricelevel' },
                            { pathName: 'proprilveditview', parameterName: 'proprilveditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-price-level-pro-prilv-edit-view/product-price-level-pro-prilv-edit-view.vue'),
                },
                {
                    path: 'productpricelevels/:productpricelevel?/proprilveditview/:proprilveditview?',
                    meta: {
                        caption: 'entities.productpricelevel.views.proprilveditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'productpricelevels', parameterName: 'productpricelevel' },
                            { pathName: 'proprilveditview', parameterName: 'proprilveditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-price-level-pro-prilv-edit-view/product-price-level-pro-prilv-edit-view.vue'),
                },
                {
                    path: 'knowledgearticles/:knowledgearticle?/knowledgearticleincidents/:knowledgearticleincident?/editview/:editview?',
                    meta: {
                        caption: 'entities.knowledgearticleincident.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'knowledgearticles', parameterName: 'knowledgearticle' },
                            { pathName: 'knowledgearticleincidents', parameterName: 'knowledgearticleincident' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/knowledge-article-incident-edit-view/knowledge-article-incident-edit-view.vue'),
                },
                {
                    path: 'knowledgearticleincidents/:knowledgearticleincident?/editview/:editview?',
                    meta: {
                        caption: 'entities.knowledgearticleincident.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'knowledgearticleincidents', parameterName: 'knowledgearticleincident' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/knowledge-article-incident-edit-view/knowledge-article-incident-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoicegridview/:invoicegridview?',
                    meta: {
                        caption: 'entities.salesorder.views.invoicegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoicegridview', parameterName: 'invoicegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-invoice-grid-view/sales-order-invoice-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoicegridview/:invoicegridview?',
                    meta: {
                        caption: 'entities.salesorder.views.invoicegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoicegridview', parameterName: 'invoicegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-invoice-grid-view/sales-order-invoice-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoicegridview/:invoicegridview?',
                    meta: {
                        caption: 'entities.salesorder.views.invoicegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoicegridview', parameterName: 'invoicegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-invoice-grid-view/sales-order-invoice-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoicegridview/:invoicegridview?',
                    meta: {
                        caption: 'entities.salesorder.views.invoicegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoicegridview', parameterName: 'invoicegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-invoice-grid-view/sales-order-invoice-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoicegridview/:invoicegridview?',
                    meta: {
                        caption: 'entities.salesorder.views.invoicegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoicegridview', parameterName: 'invoicegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-invoice-grid-view/sales-order-invoice-grid-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoicegridview/:invoicegridview?',
                    meta: {
                        caption: 'entities.salesorder.views.invoicegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoicegridview', parameterName: 'invoicegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-invoice-grid-view/sales-order-invoice-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.salesorder.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-edit-data-panel-view/sales-order-edit-data-panel-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.salesorder.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-edit-data-panel-view/sales-order-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.salesorder.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-edit-data-panel-view/sales-order-edit-data-panel-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.salesorder.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-edit-data-panel-view/sales-order-edit-data-panel-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.salesorder.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-edit-data-panel-view/sales-order-edit-data-panel-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.salesorder.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-edit-data-panel-view/sales-order-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/oppcompgridview/:oppcompgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.oppcompgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'oppcompgridview', parameterName: 'oppcompgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-opp-comp-grid-view/opportunity-competitor-opp-comp-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/oppcompgridview/:oppcompgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.oppcompgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'oppcompgridview', parameterName: 'oppcompgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-opp-comp-grid-view/opportunity-competitor-opp-comp-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/oppcompgridview/:oppcompgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.oppcompgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'oppcompgridview', parameterName: 'oppcompgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-opp-comp-grid-view/opportunity-competitor-opp-comp-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/oppcompgridview/:oppcompgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.oppcompgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'oppcompgridview', parameterName: 'oppcompgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-opp-comp-grid-view/opportunity-competitor-opp-comp-grid-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/opportunitycompetitors/:opportunitycompetitor?/oppcompgridview/:oppcompgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.oppcompgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'oppcompgridview', parameterName: 'oppcompgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-opp-comp-grid-view/opportunity-competitor-opp-comp-grid-view.vue'),
                },
                {
                    path: 'opportunitycompetitors/:opportunitycompetitor?/oppcompgridview/:oppcompgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.oppcompgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'oppcompgridview', parameterName: 'oppcompgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-opp-comp-grid-view/opportunity-competitor-opp-comp-grid-view.vue'),
                },
                {
                    path: 'goals/:goal?/info_goalview/:info_goalview?',
                    meta: {
                        caption: 'entities.goal.views.info_goalview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'info_goalview', parameterName: 'info_goalview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-info-goal-view/goal-info-goal-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.invoice.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-by-parent-key/invoice-by-parent-key.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.invoice.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-by-parent-key/invoice-by-parent-key.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.invoice.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-by-parent-key/invoice-by-parent-key.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.invoice.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-by-parent-key/invoice-by-parent-key.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.invoice.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-by-parent-key/invoice-by-parent-key.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.invoice.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-by-parent-key/invoice-by-parent-key.vue'),
                },
                {
                    path: 'invoices/:invoice?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.invoice.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-by-parent-key/invoice-by-parent-key.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/paidgridview/:paidgridview?',
                    meta: {
                        caption: 'entities.invoice.views.paidgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'paidgridview', parameterName: 'paidgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-paid-grid-view/invoice-paid-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/paidgridview/:paidgridview?',
                    meta: {
                        caption: 'entities.invoice.views.paidgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'paidgridview', parameterName: 'paidgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-paid-grid-view/invoice-paid-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/paidgridview/:paidgridview?',
                    meta: {
                        caption: 'entities.invoice.views.paidgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'paidgridview', parameterName: 'paidgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-paid-grid-view/invoice-paid-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/paidgridview/:paidgridview?',
                    meta: {
                        caption: 'entities.invoice.views.paidgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'paidgridview', parameterName: 'paidgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-paid-grid-view/invoice-paid-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/paidgridview/:paidgridview?',
                    meta: {
                        caption: 'entities.invoice.views.paidgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'paidgridview', parameterName: 'paidgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-paid-grid-view/invoice-paid-grid-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/paidgridview/:paidgridview?',
                    meta: {
                        caption: 'entities.invoice.views.paidgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'paidgridview', parameterName: 'paidgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-paid-grid-view/invoice-paid-grid-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/paidgridview/:paidgridview?',
                    meta: {
                        caption: 'entities.invoice.views.paidgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'paidgridview', parameterName: 'paidgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-paid-grid-view/invoice-paid-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.opportunity.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-grid-view/opportunity-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.opportunity.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-grid-view/opportunity-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.opportunity.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-grid-view/opportunity-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.opportunity.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-grid-view/opportunity-grid-view.vue'),
                },
                {
                    path: 'goals/:goal?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.goal.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-info-view/goal-info-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/opportunityproducts/:opportunityproduct?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunityproduct.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunityproducts', parameterName: 'opportunityproduct' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-product-edit-view/opportunity-product-edit-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/opportunityproducts/:opportunityproduct?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunityproduct.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunityproducts', parameterName: 'opportunityproduct' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-product-edit-view/opportunity-product-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/opportunityproducts/:opportunityproduct?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunityproduct.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunityproducts', parameterName: 'opportunityproduct' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-product-edit-view/opportunity-product-edit-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/opportunityproducts/:opportunityproduct?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunityproduct.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunityproducts', parameterName: 'opportunityproduct' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-product-edit-view/opportunity-product-edit-view.vue'),
                },
                {
                    path: 'opportunityproducts/:opportunityproduct?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunityproduct.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunityproducts', parameterName: 'opportunityproduct' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-product-edit-view/opportunity-product-edit-view.vue'),
                },
                {
                    path: 'emails/:email?/editview/:editview?',
                    meta: {
                        caption: 'entities.email.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'emails', parameterName: 'email' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/email-edit-view/email-edit-view.vue'),
                },
                {
                    path: 'connectionroles/:connectionrole?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.connectionrole.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'connectionroles', parameterName: 'connectionrole' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/runtime/connection-role-pickup-view/connection-role-pickup-view.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.salesliterature.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-literature-edit-data-panel-view/sales-literature-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.invoice.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-grid-view/invoice-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.invoice.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-grid-view/invoice-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.invoice.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-grid-view/invoice-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.invoice.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-grid-view/invoice-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.invoice.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-grid-view/invoice-grid-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.invoice.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-grid-view/invoice-grid-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.invoice.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-grid-view/invoice-grid-view.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.salesliterature.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-literature-quick-create-view/sales-literature-quick-create-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/usablegridview/:usablegridview?',
                    meta: {
                        caption: 'entities.contact.views.usablegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'usablegridview', parameterName: 'usablegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-usable-grid-view/contact-usable-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/usablegridview/:usablegridview?',
                    meta: {
                        caption: 'entities.contact.views.usablegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'usablegridview', parameterName: 'usablegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-usable-grid-view/contact-usable-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/info/:info?',
                    meta: {
                        caption: 'entities.quote.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-info/quote-info.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/info/:info?',
                    meta: {
                        caption: 'entities.quote.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-info/quote-info.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/info/:info?',
                    meta: {
                        caption: 'entities.quote.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-info/quote-info.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/info/:info?',
                    meta: {
                        caption: 'entities.quote.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-info/quote-info.vue'),
                },
                {
                    path: 'quotes/:quote?/info/:info?',
                    meta: {
                        caption: 'entities.quote.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-info/quote-info.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.ibizlist.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/ibiz-list-grid-view/ibiz-list-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/wingridview/:wingridview?',
                    meta: {
                        caption: 'entities.opportunity.views.wingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'wingridview', parameterName: 'wingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-win-grid-view/opportunity-win-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/wingridview/:wingridview?',
                    meta: {
                        caption: 'entities.opportunity.views.wingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'wingridview', parameterName: 'wingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-win-grid-view/opportunity-win-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/wingridview/:wingridview?',
                    meta: {
                        caption: 'entities.opportunity.views.wingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'wingridview', parameterName: 'wingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-win-grid-view/opportunity-win-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/wingridview/:wingridview?',
                    meta: {
                        caption: 'entities.opportunity.views.wingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'wingridview', parameterName: 'wingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-win-grid-view/opportunity-win-grid-view.vue'),
                },
                {
                    path: 'discounttypes/:discounttype?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.discounttype.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'discounttypes', parameterName: 'discounttype' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/discount-type-pickup-view/discount-type-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/wingridview/:wingridview?',
                    meta: {
                        caption: 'entities.quote.views.wingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'wingridview', parameterName: 'wingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-win-grid-view/quote-win-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/wingridview/:wingridview?',
                    meta: {
                        caption: 'entities.quote.views.wingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'wingridview', parameterName: 'wingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-win-grid-view/quote-win-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/wingridview/:wingridview?',
                    meta: {
                        caption: 'entities.quote.views.wingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'wingridview', parameterName: 'wingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-win-grid-view/quote-win-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/wingridview/:wingridview?',
                    meta: {
                        caption: 'entities.quote.views.wingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'wingridview', parameterName: 'wingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-win-grid-view/quote-win-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/wingridview/:wingridview?',
                    meta: {
                        caption: 'entities.quote.views.wingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'wingridview', parameterName: 'wingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-win-grid-view/quote-win-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/edit_datepanelview/:edit_datepanelview?',
                    meta: {
                        caption: 'entities.opportunity.views.edit_datepanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'edit_datepanelview', parameterName: 'edit_datepanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-edit-date-panel-view/opportunity-edit-date-panel-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/edit_datepanelview/:edit_datepanelview?',
                    meta: {
                        caption: 'entities.opportunity.views.edit_datepanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'edit_datepanelview', parameterName: 'edit_datepanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-edit-date-panel-view/opportunity-edit-date-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/edit_datepanelview/:edit_datepanelview?',
                    meta: {
                        caption: 'entities.opportunity.views.edit_datepanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'edit_datepanelview', parameterName: 'edit_datepanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-edit-date-panel-view/opportunity-edit-date-panel-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/edit_datepanelview/:edit_datepanelview?',
                    meta: {
                        caption: 'entities.opportunity.views.edit_datepanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'edit_datepanelview', parameterName: 'edit_datepanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-edit-date-panel-view/opportunity-edit-date-panel-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/info/:info?',
                    meta: {
                        caption: 'entities.ibizlist.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/ibiz-list-info/ibiz-list-info.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/closedgridview/:closedgridview?',
                    meta: {
                        caption: 'entities.quote.views.closedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'closedgridview', parameterName: 'closedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-closed-grid-view/quote-closed-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/closedgridview/:closedgridview?',
                    meta: {
                        caption: 'entities.quote.views.closedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'closedgridview', parameterName: 'closedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-closed-grid-view/quote-closed-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/closedgridview/:closedgridview?',
                    meta: {
                        caption: 'entities.quote.views.closedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'closedgridview', parameterName: 'closedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-closed-grid-view/quote-closed-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/closedgridview/:closedgridview?',
                    meta: {
                        caption: 'entities.quote.views.closedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'closedgridview', parameterName: 'closedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-closed-grid-view/quote-closed-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/closedgridview/:closedgridview?',
                    meta: {
                        caption: 'entities.quote.views.closedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'closedgridview', parameterName: 'closedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-closed-grid-view/quote-closed-grid-view.vue'),
                },
                {
                    path: 'knowledgearticles/:knowledgearticle?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.knowledgearticle.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'knowledgearticles', parameterName: 'knowledgearticle' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/knowledge-article-grid-view/knowledge-article-grid-view.vue'),
                },
                {
                    path: 'products/:product?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.product.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-quick-create-view/product-quick-create-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/info_manager/:info_manager?',
                    meta: {
                        caption: 'entities.campaign.views.info_manager.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'info_manager', parameterName: 'info_manager' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-info-manager/campaign-info-manager.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/info_abstract/:info_abstract?',
                    meta: {
                        caption: 'entities.opportunity.views.info_abstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'info_abstract', parameterName: 'info_abstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-info-abstract/opportunity-info-abstract.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/info_abstract/:info_abstract?',
                    meta: {
                        caption: 'entities.opportunity.views.info_abstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'info_abstract', parameterName: 'info_abstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-info-abstract/opportunity-info-abstract.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/info_abstract/:info_abstract?',
                    meta: {
                        caption: 'entities.opportunity.views.info_abstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'info_abstract', parameterName: 'info_abstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-info-abstract/opportunity-info-abstract.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/info_abstract/:info_abstract?',
                    meta: {
                        caption: 'entities.opportunity.views.info_abstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'info_abstract', parameterName: 'info_abstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-info-abstract/opportunity-info-abstract.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/listcontacts/:listcontact?/editview/:editview?',
                    meta: {
                        caption: 'entities.listcontact.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-edit-view/list-contact-edit-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/listcontacts/:listcontact?/editview/:editview?',
                    meta: {
                        caption: 'entities.listcontact.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-edit-view/list-contact-edit-view.vue'),
                },
                {
                    path: 'contacts/:contact?/listcontacts/:listcontact?/editview/:editview?',
                    meta: {
                        caption: 'entities.listcontact.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-edit-view/list-contact-edit-view.vue'),
                },
                {
                    path: 'listcontacts/:listcontact?/editview/:editview?',
                    meta: {
                        caption: 'entities.listcontact.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-edit-view/list-contact-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.opportunity.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-state-tab-view/opportunity-state-tab-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.opportunity.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-state-tab-view/opportunity-state-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.opportunity.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-state-tab-view/opportunity-state-tab-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.opportunity.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-state-tab-view/opportunity-state-tab-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.campaign.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-grid-view/campaign-grid-view.vue'),
                },
                {
                    path: 'knowledgearticles/:knowledgearticle?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.knowledgearticle.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'knowledgearticles', parameterName: 'knowledgearticle' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/knowledge-article-summary-view/knowledge-article-summary-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/effectivegridview/:effectivegridview?',
                    meta: {
                        caption: 'entities.campaign.views.effectivegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'effectivegridview', parameterName: 'effectivegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-effective-grid-view/campaign-effective-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/listleads/:listlead?/bylist/:bylist?',
                    meta: {
                        caption: 'entities.listlead.views.bylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'bylist', parameterName: 'bylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-by-list/list-lead-by-list.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/listleads/:listlead?/bylist/:bylist?',
                    meta: {
                        caption: 'entities.listlead.views.bylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'bylist', parameterName: 'bylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-by-list/list-lead-by-list.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/listleads/:listlead?/bylist/:bylist?',
                    meta: {
                        caption: 'entities.listlead.views.bylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'bylist', parameterName: 'bylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-by-list/list-lead-by-list.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/listleads/:listlead?/bylist/:bylist?',
                    meta: {
                        caption: 'entities.listlead.views.bylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'bylist', parameterName: 'bylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-by-list/list-lead-by-list.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/listleads/:listlead?/bylist/:bylist?',
                    meta: {
                        caption: 'entities.listlead.views.bylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'bylist', parameterName: 'bylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-by-list/list-lead-by-list.vue'),
                },
                {
                    path: 'leads/:lead?/listleads/:listlead?/bylist/:bylist?',
                    meta: {
                        caption: 'entities.listlead.views.bylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'bylist', parameterName: 'bylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-by-list/list-lead-by-list.vue'),
                },
                {
                    path: 'listleads/:listlead?/bylist/:bylist?',
                    meta: {
                        caption: 'entities.listlead.views.bylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'bylist', parameterName: 'bylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-by-list/list-lead-by-list.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/leadcompetitors/:leadcompetitor?/competitorgridview/:competitorgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.competitorgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'competitorgridview', parameterName: 'competitorgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-competitor-grid-view/lead-competitor-competitor-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/leadcompetitors/:leadcompetitor?/competitorgridview/:competitorgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.competitorgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'competitorgridview', parameterName: 'competitorgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-competitor-grid-view/lead-competitor-competitor-grid-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/leadcompetitors/:leadcompetitor?/competitorgridview/:competitorgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.competitorgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'competitorgridview', parameterName: 'competitorgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-competitor-grid-view/lead-competitor-competitor-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/leadcompetitors/:leadcompetitor?/competitorgridview/:competitorgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.competitorgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'competitorgridview', parameterName: 'competitorgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-competitor-grid-view/lead-competitor-competitor-grid-view.vue'),
                },
                {
                    path: 'leads/:lead?/leadcompetitors/:leadcompetitor?/competitorgridview/:competitorgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.competitorgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'competitorgridview', parameterName: 'competitorgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-competitor-grid-view/lead-competitor-competitor-grid-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/leadcompetitors/:leadcompetitor?/competitorgridview/:competitorgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.competitorgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'competitorgridview', parameterName: 'competitorgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-competitor-grid-view/lead-competitor-competitor-grid-view.vue'),
                },
                {
                    path: 'leadcompetitors/:leadcompetitor?/competitorgridview/:competitorgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.competitorgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'competitorgridview', parameterName: 'competitorgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-competitor-grid-view/lead-competitor-competitor-grid-view.vue'),
                },
                {
                    path: 'campaignactivities/:campaignactivity?/editview/:editview?',
                    meta: {
                        caption: 'entities.campaignactivity.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaignactivities', parameterName: 'campaignactivity' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-activity-edit-view/campaign-activity-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.contact.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-quick-create/contact-quick-create.vue'),
                },
                {
                    path: 'contacts/:contact?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.contact.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-quick-create/contact-quick-create.vue'),
                },
                {
                    path: 'campaigns/:campaign?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.campaign.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-edit-data-panel-view/campaign-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.quote.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-by-parent-key/quote-by-parent-key.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.quote.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-by-parent-key/quote-by-parent-key.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.quote.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-by-parent-key/quote-by-parent-key.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.quote.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-by-parent-key/quote-by-parent-key.vue'),
                },
                {
                    path: 'quotes/:quote?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.quote.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-by-parent-key/quote-by-parent-key.vue'),
                },
                {
                    path: 'metrics/:metric?/editview/:editview?',
                    meta: {
                        caption: 'entities.metric.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'metrics', parameterName: 'metric' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/metric-edit-view/metric-edit-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/info_abstract/:info_abstract?',
                    meta: {
                        caption: 'entities.competitor.views.info_abstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'info_abstract', parameterName: 'info_abstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-info-abstract/competitor-info-abstract.vue'),
                },
                {
                    path: 'knowledgearticles/:knowledgearticle?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.knowledgearticle.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'knowledgearticles', parameterName: 'knowledgearticle' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/knowledge-article-info-view/knowledge-article-info-view.vue'),
                },
                {
                    path: 'phonecalls/:phonecall?/editview/:editview?',
                    meta: {
                        caption: 'entities.phonecall.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'phonecalls', parameterName: 'phonecall' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/phone-call-edit-view/phone-call-edit-view.vue'),
                },
                {
                    path: 'connections/:connection?/editview/:editview?',
                    meta: {
                        caption: 'entities.connection.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'connections', parameterName: 'connection' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/runtime/connection-edit-view/connection-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.invoice.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-summary-view/invoice-summary-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.invoice.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-summary-view/invoice-summary-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.invoice.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-summary-view/invoice-summary-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.invoice.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-summary-view/invoice-summary-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.invoice.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-summary-view/invoice-summary-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.invoice.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-summary-view/invoice-summary-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.invoice.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-summary-view/invoice-summary-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/info_contact/:info_contact?',
                    meta: {
                        caption: 'entities.lead.views.info_contact.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'info_contact', parameterName: 'info_contact' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-info-contact/lead-info-contact.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/info_contact/:info_contact?',
                    meta: {
                        caption: 'entities.lead.views.info_contact.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'info_contact', parameterName: 'info_contact' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-info-contact/lead-info-contact.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/info_contact/:info_contact?',
                    meta: {
                        caption: 'entities.lead.views.info_contact.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'info_contact', parameterName: 'info_contact' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-info-contact/lead-info-contact.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/info_contact/:info_contact?',
                    meta: {
                        caption: 'entities.lead.views.info_contact.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'info_contact', parameterName: 'info_contact' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-info-contact/lead-info-contact.vue'),
                },
                {
                    path: 'leads/:lead?/info_contact/:info_contact?',
                    meta: {
                        caption: 'entities.lead.views.info_contact.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'info_contact', parameterName: 'info_contact' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-info-contact/lead-info-contact.vue'),
                },
                {
                    path: 'accounts/:account?/summary/:summary?',
                    meta: {
                        caption: 'entities.account.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-summary/account-summary.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.salesliterature.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-literature-info-view/sales-literature-info-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/quotedetails/:quotedetail?/quodetailgridview/:quodetailgridview?',
                    meta: {
                        caption: 'entities.quotedetail.views.quodetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'quodetailgridview', parameterName: 'quodetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-quo-detail-grid-view/quote-detail-quo-detail-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/quotedetails/:quotedetail?/quodetailgridview/:quodetailgridview?',
                    meta: {
                        caption: 'entities.quotedetail.views.quodetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'quodetailgridview', parameterName: 'quodetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-quo-detail-grid-view/quote-detail-quo-detail-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/quotedetails/:quotedetail?/quodetailgridview/:quodetailgridview?',
                    meta: {
                        caption: 'entities.quotedetail.views.quodetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'quodetailgridview', parameterName: 'quodetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-quo-detail-grid-view/quote-detail-quo-detail-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/quotedetails/:quotedetail?/quodetailgridview/:quodetailgridview?',
                    meta: {
                        caption: 'entities.quotedetail.views.quodetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'quodetailgridview', parameterName: 'quodetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-quo-detail-grid-view/quote-detail-quo-detail-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/quotedetails/:quotedetail?/quodetailgridview/:quodetailgridview?',
                    meta: {
                        caption: 'entities.quotedetail.views.quodetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'quodetailgridview', parameterName: 'quodetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-quo-detail-grid-view/quote-detail-quo-detail-grid-view.vue'),
                },
                {
                    path: 'quotedetails/:quotedetail?/quodetailgridview/:quodetailgridview?',
                    meta: {
                        caption: 'entities.quotedetail.views.quodetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'quodetailgridview', parameterName: 'quodetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-quo-detail-grid-view/quote-detail-quo-detail-grid-view.vue'),
                },
                {
                    path: 'campaignactivities/:campaignactivity?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.campaignactivity.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaignactivities', parameterName: 'campaignactivity' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-activity-quick-create/campaign-activity-quick-create.vue'),
                },
                {
                    path: 'competitors/:competitor?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.competitor.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-edit-data-panel-view/competitor-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/listcontacts/:listcontact?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.listcontact.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-grid-view/list-contact-grid-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/listcontacts/:listcontact?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.listcontact.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-grid-view/list-contact-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/listcontacts/:listcontact?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.listcontact.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-grid-view/list-contact-grid-view.vue'),
                },
                {
                    path: 'listcontacts/:listcontact?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.listcontact.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-grid-view/list-contact-grid-view.vue'),
                },
                {
                    path: 'faxes/:fax?/editview/:editview?',
                    meta: {
                        caption: 'entities.fax.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'faxes', parameterName: 'fax' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/fax-edit-view/fax-edit-view.vue'),
                },
                {
                    path: 'incidents/:incident?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.incident.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-quick-create-view/incident-quick-create-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/campaignlists/:campaignlist?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.campaignlist.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'campaignlists', parameterName: 'campaignlist' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-list-grid-view/campaign-list-grid-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/campaignlists/:campaignlist?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.campaignlist.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'campaignlists', parameterName: 'campaignlist' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-list-grid-view/campaign-list-grid-view.vue'),
                },
                {
                    path: 'campaignlists/:campaignlist?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.campaignlist.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaignlists', parameterName: 'campaignlist' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-list-grid-view/campaign-list-grid-view.vue'),
                },
                {
                    path: 'activitypointers/:activitypointer?/editview/:editview?',
                    meta: {
                        caption: 'entities.activitypointer.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'activitypointers', parameterName: 'activitypointer' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/activity-pointer-edit-view/activity-pointer-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.lead.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-grid-view/lead-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.lead.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-grid-view/lead-grid-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.lead.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-grid-view/lead-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.lead.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-grid-view/lead-grid-view.vue'),
                },
                {
                    path: 'leads/:lead?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.lead.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-grid-view/lead-grid-view.vue'),
                },
                {
                    path: 'subjects/:subject?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.subject.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'subjects', parameterName: 'subject' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/subject-pickup-view/subject-pickup-view.vue'),
                },
                {
                    path: 'goals/:goal?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.goal.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-quick-create-view/goal-quick-create-view.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.salesliterature.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-literature-grid-view/sales-literature-grid-view.vue'),
                },
                {
                    path: 'incidents/:incident?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.incident.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-info-view/incident-info-view.vue'),
                },
                {
                    path: 'knowledgearticles/:knowledgearticle?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.knowledgearticle.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'knowledgearticles', parameterName: 'knowledgearticle' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/knowledge-article-quick-create-view/knowledge-article-quick-create-view.vue'),
                },
                {
                    path: 'multipickdata/:multipickdata?/acgrid/:acgrid?',
                    meta: {
                        caption: 'entities.multipickdata.views.acgrid.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'multipickdata', parameterName: 'multipickdata' },
                            { pathName: 'acgrid', parameterName: 'acgrid' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/multi-pick-data-acgrid/multi-pick-data-acgrid.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/summary/:summary?',
                    meta: {
                        caption: 'entities.opportunity.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-summary/opportunity-summary.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/summary/:summary?',
                    meta: {
                        caption: 'entities.opportunity.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-summary/opportunity-summary.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/summary/:summary?',
                    meta: {
                        caption: 'entities.opportunity.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-summary/opportunity-summary.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/summary/:summary?',
                    meta: {
                        caption: 'entities.opportunity.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-summary/opportunity-summary.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.quote.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-edit-data-panel-view/quote-edit-data-panel-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.quote.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-edit-data-panel-view/quote-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.quote.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-edit-data-panel-view/quote-edit-data-panel-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.quote.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-edit-data-panel-view/quote-edit-data-panel-view.vue'),
                },
                {
                    path: 'quotes/:quote?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.quote.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-edit-data-panel-view/quote-edit-data-panel-view.vue'),
                },
                {
                    path: 'goals/:goal?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.goal.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-pickup-grid-view/goal-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/info/:info?',
                    meta: {
                        caption: 'entities.contact.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-info/contact-info.vue'),
                },
                {
                    path: 'contacts/:contact?/info/:info?',
                    meta: {
                        caption: 'entities.contact.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-info/contact-info.vue'),
                },
                {
                    path: 'campaigns/:campaign?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.campaign.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-state-tab-view/campaign-state-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/summary/:summary?',
                    meta: {
                        caption: 'entities.quote.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-summary/quote-summary.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/summary/:summary?',
                    meta: {
                        caption: 'entities.quote.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-summary/quote-summary.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/summary/:summary?',
                    meta: {
                        caption: 'entities.quote.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-summary/quote-summary.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/summary/:summary?',
                    meta: {
                        caption: 'entities.quote.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-summary/quote-summary.vue'),
                },
                {
                    path: 'quotes/:quote?/summary/:summary?',
                    meta: {
                        caption: 'entities.quote.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-summary/quote-summary.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.contact.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-pickup-grid-view/contact-pickup-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.contact.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-pickup-grid-view/contact-pickup-grid-view.vue'),
                },
                {
                    path: 'knowledgearticles/:knowledgearticle?/knowledgearticleincidents/:knowledgearticleincident?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.knowledgearticleincident.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'knowledgearticles', parameterName: 'knowledgearticle' },
                            { pathName: 'knowledgearticleincidents', parameterName: 'knowledgearticleincident' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/knowledge-article-incident-grid-view/knowledge-article-incident-grid-view.vue'),
                },
                {
                    path: 'knowledgearticleincidents/:knowledgearticleincident?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.knowledgearticleincident.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'knowledgearticleincidents', parameterName: 'knowledgearticleincident' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/knowledge-article-incident-grid-view/knowledge-article-incident-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/invoiceprogridview/:invoiceprogridview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.invoiceprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'invoiceprogridview', parameterName: 'invoiceprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-invoice-pro-grid-view/invoice-detail-invoice-pro-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/invoiceprogridview/:invoiceprogridview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.invoiceprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'invoiceprogridview', parameterName: 'invoiceprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-invoice-pro-grid-view/invoice-detail-invoice-pro-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/invoiceprogridview/:invoiceprogridview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.invoiceprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'invoiceprogridview', parameterName: 'invoiceprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-invoice-pro-grid-view/invoice-detail-invoice-pro-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/invoiceprogridview/:invoiceprogridview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.invoiceprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'invoiceprogridview', parameterName: 'invoiceprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-invoice-pro-grid-view/invoice-detail-invoice-pro-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/invoiceprogridview/:invoiceprogridview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.invoiceprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'invoiceprogridview', parameterName: 'invoiceprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-invoice-pro-grid-view/invoice-detail-invoice-pro-grid-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/invoiceprogridview/:invoiceprogridview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.invoiceprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'invoiceprogridview', parameterName: 'invoiceprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-invoice-pro-grid-view/invoice-detail-invoice-pro-grid-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/invoicedetails/:invoicedetail?/invoiceprogridview/:invoiceprogridview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.invoiceprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'invoiceprogridview', parameterName: 'invoiceprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-invoice-pro-grid-view/invoice-detail-invoice-pro-grid-view.vue'),
                },
                {
                    path: 'invoicedetails/:invoicedetail?/invoiceprogridview/:invoiceprogridview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.invoiceprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'invoiceprogridview', parameterName: 'invoiceprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-invoice-pro-grid-view/invoice-detail-invoice-pro-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/info/:info?',
                    meta: {
                        caption: 'entities.opportunity.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-info/opportunity-info.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/info/:info?',
                    meta: {
                        caption: 'entities.opportunity.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-info/opportunity-info.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/info/:info?',
                    meta: {
                        caption: 'entities.opportunity.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-info/opportunity-info.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/info/:info?',
                    meta: {
                        caption: 'entities.opportunity.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-info/opportunity-info.vue'),
                },
                {
                    path: 'serviceappointments/:serviceappointment?/editview/:editview?',
                    meta: {
                        caption: 'entities.serviceappointment.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'serviceappointments', parameterName: 'serviceappointment' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/service-appointment-edit-view/service-appointment-edit-view.vue'),
                },
                {
                    path: 'transactioncurrencies/:transactioncurrency?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.transactioncurrency.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'transactioncurrencies', parameterName: 'transactioncurrency' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/transaction-currency-pickup-grid-view/transaction-currency-pickup-grid-view.vue'),
                },
                {
                    path: 'products/:product?/productsubstitutes/:productsubstitute?/editview/:editview?',
                    meta: {
                        caption: 'entities.productsubstitute.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'productsubstitutes', parameterName: 'productsubstitute' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-substitute-edit-view/product-substitute-edit-view.vue'),
                },
                {
                    path: 'productsubstitutes/:productsubstitute?/editview/:editview?',
                    meta: {
                        caption: 'entities.productsubstitute.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'productsubstitutes', parameterName: 'productsubstitute' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-substitute-edit-view/product-substitute-edit-view.vue'),
                },
                {
                    path: 'activitypointers/:activitypointer?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.activitypointer.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'activitypointers', parameterName: 'activitypointer' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/activity-pointer-grid-view/activity-pointer-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.account.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-pickup-view/account-pickup-view.vue'),
                },
                {
                    path: 'uoms/:uom?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.uom.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'uoms', parameterName: 'uom' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/uom-pickup-grid-view/uom-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.invoice.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-view/invoice-info-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.invoice.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-view/invoice-info-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.invoice.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-view/invoice-info-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.invoice.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-view/invoice-info-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.invoice.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-view/invoice-info-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.invoice.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-view/invoice-info-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.invoice.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-info-view/invoice-info-view.vue'),
                },
                {
                    path: 'connectionroles/:connectionrole?/editview/:editview?',
                    meta: {
                        caption: 'entities.connectionrole.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'connectionroles', parameterName: 'connectionrole' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/runtime/connection-role-edit-view/connection-role-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/byaccount/:byaccount?',
                    meta: {
                        caption: 'entities.contact.views.byaccount.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'byaccount', parameterName: 'byaccount' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-by-account/contact-by-account.vue'),
                },
                {
                    path: 'contacts/:contact?/byaccount/:byaccount?',
                    meta: {
                        caption: 'entities.contact.views.byaccount.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'byaccount', parameterName: 'byaccount' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-by-account/contact-by-account.vue'),
                },
                {
                    path: 'multipickdata/:multipickdata?/ac/:ac?',
                    meta: {
                        caption: 'entities.multipickdata.views.ac.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'multipickdata', parameterName: 'multipickdata' },
                            { pathName: 'ac', parameterName: 'ac' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/multi-pick-data-ac/multi-pick-data-ac.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/summary/:summary?',
                    meta: {
                        caption: 'entities.ibizlist.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/ibiz-list-summary/ibiz-list-summary.vue'),
                },
                {
                    path: 'campaigns/:campaign?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.campaign.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-quick-create-view/campaign-quick-create-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/conoppgridview/:conoppgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.conoppgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'conoppgridview', parameterName: 'conoppgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-con-opp-grid-view/opportunity-con-opp-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/conoppgridview/:conoppgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.conoppgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'conoppgridview', parameterName: 'conoppgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-con-opp-grid-view/opportunity-con-opp-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/conoppgridview/:conoppgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.conoppgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'conoppgridview', parameterName: 'conoppgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-con-opp-grid-view/opportunity-con-opp-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/conoppgridview/:conoppgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.conoppgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'conoppgridview', parameterName: 'conoppgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-con-opp-grid-view/opportunity-con-opp-grid-view.vue'),
                },
                {
                    path: 'discounttypes/:discounttype?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.discounttype.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'discounttypes', parameterName: 'discounttype' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/discount-type-pickup-grid-view/discount-type-pickup-grid-view.vue'),
                },
                {
                    path: 'campaignresponses/:campaignresponse?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.campaignresponse.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaignresponses', parameterName: 'campaignresponse' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-response-quick-create/campaign-response-quick-create.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-cancel-grid-view/sales-order-cancel-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-cancel-grid-view/sales-order-cancel-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-cancel-grid-view/sales-order-cancel-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-cancel-grid-view/sales-order-cancel-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-cancel-grid-view/sales-order-cancel-grid-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-cancel-grid-view/sales-order-cancel-grid-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/campaignlists/:campaignlist?/editview/:editview?',
                    meta: {
                        caption: 'entities.campaignlist.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'campaignlists', parameterName: 'campaignlist' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-list-edit-view/campaign-list-edit-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/campaignlists/:campaignlist?/editview/:editview?',
                    meta: {
                        caption: 'entities.campaignlist.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'campaignlists', parameterName: 'campaignlist' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-list-edit-view/campaign-list-edit-view.vue'),
                },
                {
                    path: 'campaignlists/:campaignlist?/editview/:editview?',
                    meta: {
                        caption: 'entities.campaignlist.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaignlists', parameterName: 'campaignlist' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-list-edit-view/campaign-list-edit-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/info/:info?',
                    meta: {
                        caption: 'entities.competitor.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-info/competitor-info.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/excludedgridview/:excludedgridview?',
                    meta: {
                        caption: 'entities.lead.views.excludedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'excludedgridview', parameterName: 'excludedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-excluded-grid-view/lead-excluded-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/excludedgridview/:excludedgridview?',
                    meta: {
                        caption: 'entities.lead.views.excludedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'excludedgridview', parameterName: 'excludedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-excluded-grid-view/lead-excluded-grid-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/excludedgridview/:excludedgridview?',
                    meta: {
                        caption: 'entities.lead.views.excludedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'excludedgridview', parameterName: 'excludedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-excluded-grid-view/lead-excluded-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/excludedgridview/:excludedgridview?',
                    meta: {
                        caption: 'entities.lead.views.excludedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'excludedgridview', parameterName: 'excludedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-excluded-grid-view/lead-excluded-grid-view.vue'),
                },
                {
                    path: 'leads/:lead?/excludedgridview/:excludedgridview?',
                    meta: {
                        caption: 'entities.lead.views.excludedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'excludedgridview', parameterName: 'excludedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-excluded-grid-view/lead-excluded-grid-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/competitorproducts/:competitorproduct?/edit_compproview/:edit_compproview?',
                    meta: {
                        caption: 'entities.competitorproduct.views.edit_compproview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'competitorproducts', parameterName: 'competitorproduct' },
                            { pathName: 'edit_compproview', parameterName: 'edit_compproview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-product-edit-comp-pro-view/competitor-product-edit-comp-pro-view.vue'),
                },
                {
                    path: 'competitorproducts/:competitorproduct?/edit_compproview/:edit_compproview?',
                    meta: {
                        caption: 'entities.competitorproduct.views.edit_compproview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitorproducts', parameterName: 'competitorproduct' },
                            { pathName: 'edit_compproview', parameterName: 'edit_compproview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-product-edit-comp-pro-view/competitor-product-edit-comp-pro-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/info/:info?',
                    meta: {
                        caption: 'entities.lead.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-info/lead-info.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/info/:info?',
                    meta: {
                        caption: 'entities.lead.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-info/lead-info.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/info/:info?',
                    meta: {
                        caption: 'entities.lead.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-info/lead-info.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/info/:info?',
                    meta: {
                        caption: 'entities.lead.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-info/lead-info.vue'),
                },
                {
                    path: 'leads/:lead?/info/:info?',
                    meta: {
                        caption: 'entities.lead.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-info/lead-info.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/finishgridview/:finishgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.finishgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'finishgridview', parameterName: 'finishgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-finish-grid-view/sales-order-finish-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/finishgridview/:finishgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.finishgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'finishgridview', parameterName: 'finishgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-finish-grid-view/sales-order-finish-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/finishgridview/:finishgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.finishgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'finishgridview', parameterName: 'finishgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-finish-grid-view/sales-order-finish-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/finishgridview/:finishgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.finishgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'finishgridview', parameterName: 'finishgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-finish-grid-view/sales-order-finish-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/finishgridview/:finishgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.finishgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'finishgridview', parameterName: 'finishgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-finish-grid-view/sales-order-finish-grid-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/finishgridview/:finishgridview?',
                    meta: {
                        caption: 'entities.salesorder.views.finishgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'finishgridview', parameterName: 'finishgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-finish-grid-view/sales-order-finish-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/ongridview/:ongridview?',
                    meta: {
                        caption: 'entities.lead.views.ongridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'ongridview', parameterName: 'ongridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-on-grid-view/lead-on-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/ongridview/:ongridview?',
                    meta: {
                        caption: 'entities.lead.views.ongridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'ongridview', parameterName: 'ongridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-on-grid-view/lead-on-grid-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/ongridview/:ongridview?',
                    meta: {
                        caption: 'entities.lead.views.ongridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'ongridview', parameterName: 'ongridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-on-grid-view/lead-on-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/ongridview/:ongridview?',
                    meta: {
                        caption: 'entities.lead.views.ongridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'ongridview', parameterName: 'ongridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-on-grid-view/lead-on-grid-view.vue'),
                },
                {
                    path: 'leads/:lead?/ongridview/:ongridview?',
                    meta: {
                        caption: 'entities.lead.views.ongridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'ongridview', parameterName: 'ongridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-on-grid-view/lead-on-grid-view.vue'),
                },
                {
                    path: 'products/:product?/revisegridview/:revisegridview?',
                    meta: {
                        caption: 'entities.product.views.revisegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'revisegridview', parameterName: 'revisegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-revise-grid-view/product-revise-grid-view.vue'),
                },
                {
                    path: 'transactioncurrencies/:transactioncurrency?/editview/:editview?',
                    meta: {
                        caption: 'entities.transactioncurrency.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'transactioncurrencies', parameterName: 'transactioncurrency' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/transaction-currency-edit-view/transaction-currency-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/soproductgridview/:soproductgridview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.soproductgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'soproductgridview', parameterName: 'soproductgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-soproduct-grid-view/sales-order-detail-soproduct-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/soproductgridview/:soproductgridview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.soproductgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'soproductgridview', parameterName: 'soproductgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-soproduct-grid-view/sales-order-detail-soproduct-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/soproductgridview/:soproductgridview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.soproductgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'soproductgridview', parameterName: 'soproductgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-soproduct-grid-view/sales-order-detail-soproduct-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/soproductgridview/:soproductgridview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.soproductgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'soproductgridview', parameterName: 'soproductgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-soproduct-grid-view/sales-order-detail-soproduct-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/soproductgridview/:soproductgridview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.soproductgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'soproductgridview', parameterName: 'soproductgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-soproduct-grid-view/sales-order-detail-soproduct-grid-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/soproductgridview/:soproductgridview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.soproductgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'soproductgridview', parameterName: 'soproductgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-soproduct-grid-view/sales-order-detail-soproduct-grid-view.vue'),
                },
                {
                    path: 'salesorderdetails/:salesorderdetail?/soproductgridview/:soproductgridview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.soproductgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'soproductgridview', parameterName: 'soproductgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-soproduct-grid-view/sales-order-detail-soproduct-grid-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/summary/:summary?',
                    meta: {
                        caption: 'entities.campaign.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-summary/campaign-summary.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-view/opportunity-competitor-edit-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-view/opportunity-competitor-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-view/opportunity-competitor-edit-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-view/opportunity-competitor-edit-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/opportunitycompetitors/:opportunitycompetitor?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-view/opportunity-competitor-edit-view.vue'),
                },
                {
                    path: 'opportunitycompetitors/:opportunitycompetitor?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-view/opportunity-competitor-edit-view.vue'),
                },
                {
                    path: 'incidents/:incident?/info_incidentview/:info_incidentview?',
                    meta: {
                        caption: 'entities.incident.views.info_incidentview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'info_incidentview', parameterName: 'info_incidentview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-info-incident-view/incident-info-incident-view.vue'),
                },
                {
                    path: 'accounts/:account?/usablegridview/:usablegridview?',
                    meta: {
                        caption: 'entities.account.views.usablegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'usablegridview', parameterName: 'usablegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-usable-grid-view/account-usable-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/info_soview/:info_soview?',
                    meta: {
                        caption: 'entities.salesorder.views.info_soview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'info_soview', parameterName: 'info_soview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-soview/sales-order-info-soview.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/info_soview/:info_soview?',
                    meta: {
                        caption: 'entities.salesorder.views.info_soview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'info_soview', parameterName: 'info_soview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-soview/sales-order-info-soview.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/info_soview/:info_soview?',
                    meta: {
                        caption: 'entities.salesorder.views.info_soview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'info_soview', parameterName: 'info_soview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-soview/sales-order-info-soview.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/info_soview/:info_soview?',
                    meta: {
                        caption: 'entities.salesorder.views.info_soview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'info_soview', parameterName: 'info_soview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-soview/sales-order-info-soview.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/info_soview/:info_soview?',
                    meta: {
                        caption: 'entities.salesorder.views.info_soview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'info_soview', parameterName: 'info_soview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-soview/sales-order-info-soview.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/info_soview/:info_soview?',
                    meta: {
                        caption: 'entities.salesorder.views.info_soview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'info_soview', parameterName: 'info_soview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-soview/sales-order-info-soview.vue'),
                },
                {
                    path: 'accounts/:account?/innerpickupgridview/:innerpickupgridview?',
                    meta: {
                        caption: 'entities.account.views.innerpickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'innerpickupgridview', parameterName: 'innerpickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-inner-pickup-grid-view/account-inner-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.quote.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-state-tab-view/quote-state-tab-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.quote.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-state-tab-view/quote-state-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.quote.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-state-tab-view/quote-state-tab-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.quote.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-state-tab-view/quote-state-tab-view.vue'),
                },
                {
                    path: 'quotes/:quote?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.quote.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-state-tab-view/quote-state-tab-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.campaign.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-pickup-view/campaign-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.salesorder.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-summary-view/sales-order-summary-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.salesorder.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-summary-view/sales-order-summary-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.salesorder.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-summary-view/sales-order-summary-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.salesorder.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-summary-view/sales-order-summary-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.salesorder.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-summary-view/sales-order-summary-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.salesorder.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-summary-view/sales-order-summary-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/quotedetails/:quotedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.quotedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-edit-view/quote-detail-edit-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/quotedetails/:quotedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.quotedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-edit-view/quote-detail-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/quotedetails/:quotedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.quotedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-edit-view/quote-detail-edit-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/quotedetails/:quotedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.quotedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-edit-view/quote-detail-edit-view.vue'),
                },
                {
                    path: 'quotes/:quote?/quotedetails/:quotedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.quotedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-edit-view/quote-detail-edit-view.vue'),
                },
                {
                    path: 'quotedetails/:quotedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.quotedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotedetails', parameterName: 'quotedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-detail-edit-view/quote-detail-edit-view.vue'),
                },
                {
                    path: 'products/:product?/stopgridview/:stopgridview?',
                    meta: {
                        caption: 'entities.product.views.stopgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'stopgridview', parameterName: 'stopgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-stop-grid-view/product-stop-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/editview/:editview?',
                    meta: {
                        caption: 'entities.quote.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-edit-view/quote-edit-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/editview/:editview?',
                    meta: {
                        caption: 'entities.quote.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-edit-view/quote-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/editview/:editview?',
                    meta: {
                        caption: 'entities.quote.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-edit-view/quote-edit-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/editview/:editview?',
                    meta: {
                        caption: 'entities.quote.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-edit-view/quote-edit-view.vue'),
                },
                {
                    path: 'quotes/:quote?/editview/:editview?',
                    meta: {
                        caption: 'entities.quote.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-edit-view/quote-edit-view.vue'),
                },
                {
                    path: 'incidents/:incident?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.incident.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-grid-view/incident-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/innerpickupview/:innerpickupview?',
                    meta: {
                        caption: 'entities.account.views.innerpickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'innerpickupview', parameterName: 'innerpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-inner-pickup-view/account-inner-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.account.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-quick-create/account-quick-create.vue'),
                },
                {
                    path: 'incidents/:incident?/edit_chlidincident/:edit_chlidincident?',
                    meta: {
                        caption: 'entities.incident.views.edit_chlidincident.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'edit_chlidincident', parameterName: 'edit_chlidincident' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-edit-chlid-incident/incident-edit-chlid-incident.vue'),
                },
                {
                    path: 'products/:product?/productpricelevels/:productpricelevel?/proprilvgridview/:proprilvgridview?',
                    meta: {
                        caption: 'entities.productpricelevel.views.proprilvgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'productpricelevels', parameterName: 'productpricelevel' },
                            { pathName: 'proprilvgridview', parameterName: 'proprilvgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-price-level-pro-prilv-grid-view/product-price-level-pro-prilv-grid-view.vue'),
                },
                {
                    path: 'productpricelevels/:productpricelevel?/proprilvgridview/:proprilvgridview?',
                    meta: {
                        caption: 'entities.productpricelevel.views.proprilvgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'productpricelevels', parameterName: 'productpricelevel' },
                            { pathName: 'proprilvgridview', parameterName: 'proprilvgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-price-level-pro-prilv-grid-view/product-price-level-pro-prilv-grid-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/listaccounts/:listaccount?/bylist/:bylist?',
                    meta: {
                        caption: 'entities.listaccount.views.bylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'bylist', parameterName: 'bylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-by-list/list-account-by-list.vue'),
                },
                {
                    path: 'accounts/:account?/listaccounts/:listaccount?/bylist/:bylist?',
                    meta: {
                        caption: 'entities.listaccount.views.bylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'bylist', parameterName: 'bylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-by-list/list-account-by-list.vue'),
                },
                {
                    path: 'listaccounts/:listaccount?/bylist/:bylist?',
                    meta: {
                        caption: 'entities.listaccount.views.bylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'bylist', parameterName: 'bylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-by-list/list-account-by-list.vue'),
                },
                {
                    path: 'products/:product?/info_proinfo/:info_proinfo?',
                    meta: {
                        caption: 'entities.product.views.info_proinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'info_proinfo', parameterName: 'info_proinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-info-pro-info/product-info-pro-info.vue'),
                },
                {
                    path: 'campaignresponses/:campaignresponse?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.campaignresponse.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaignresponses', parameterName: 'campaignresponse' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-response-by-parent-key/campaign-response-by-parent-key.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.salesliterature.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-literature-summary-view/sales-literature-summary-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.lead.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-pickup-view/lead-pickup-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.lead.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-pickup-view/lead-pickup-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.lead.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-pickup-view/lead-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.lead.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-pickup-view/lead-pickup-view.vue'),
                },
                {
                    path: 'leads/:lead?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.lead.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-pickup-view/lead-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.invoice.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-state-tab-view/invoice-state-tab-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.invoice.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-state-tab-view/invoice-state-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.invoice.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-state-tab-view/invoice-state-tab-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.invoice.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-state-tab-view/invoice-state-tab-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.invoice.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-state-tab-view/invoice-state-tab-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.invoice.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-state-tab-view/invoice-state-tab-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.invoice.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-state-tab-view/invoice-state-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.lead.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-edit-data-panel-view/lead-edit-data-panel-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.lead.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-edit-data-panel-view/lead-edit-data-panel-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.lead.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-edit-data-panel-view/lead-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.lead.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-edit-data-panel-view/lead-edit-data-panel-view.vue'),
                },
                {
                    path: 'leads/:lead?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.lead.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-edit-data-panel-view/lead-edit-data-panel-view.vue'),
                },
                {
                    path: 'products/:product?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.product.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-state-tab-view/product-state-tab-view.vue'),
                },
                {
                    path: 'setting/:setting?',
                    meta: {
                        caption: 'app.views.setting.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'setting', parameterName: 'setting' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ungroup/setting/setting.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.invoice.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-quick-create-view/invoice-quick-create-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.invoice.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-quick-create-view/invoice-quick-create-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.invoice.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-quick-create-view/invoice-quick-create-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.invoice.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-quick-create-view/invoice-quick-create-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.invoice.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-quick-create-view/invoice-quick-create-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.invoice.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-quick-create-view/invoice-quick-create-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.invoice.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-quick-create-view/invoice-quick-create-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/info_schedule/:info_schedule?',
                    meta: {
                        caption: 'entities.campaign.views.info_schedule.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'info_schedule', parameterName: 'info_schedule' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-info-schedule/campaign-info-schedule.vue'),
                },
                {
                    path: 'competitors/:competitor?/competitorproducts/:competitorproduct?/compprogridview/:compprogridview?',
                    meta: {
                        caption: 'entities.competitorproduct.views.compprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'competitorproducts', parameterName: 'competitorproduct' },
                            { pathName: 'compprogridview', parameterName: 'compprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-product-comp-pro-grid-view/competitor-product-comp-pro-grid-view.vue'),
                },
                {
                    path: 'competitorproducts/:competitorproduct?/compprogridview/:compprogridview?',
                    meta: {
                        caption: 'entities.competitorproduct.views.compprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitorproducts', parameterName: 'competitorproduct' },
                            { pathName: 'compprogridview', parameterName: 'compprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-product-comp-pro-grid-view/competitor-product-comp-pro-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/conleadgridview/:conleadgridview?',
                    meta: {
                        caption: 'entities.lead.views.conleadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'conleadgridview', parameterName: 'conleadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-con-lead-grid-view/lead-con-lead-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/conleadgridview/:conleadgridview?',
                    meta: {
                        caption: 'entities.lead.views.conleadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'conleadgridview', parameterName: 'conleadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-con-lead-grid-view/lead-con-lead-grid-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/conleadgridview/:conleadgridview?',
                    meta: {
                        caption: 'entities.lead.views.conleadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'conleadgridview', parameterName: 'conleadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-con-lead-grid-view/lead-con-lead-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/conleadgridview/:conleadgridview?',
                    meta: {
                        caption: 'entities.lead.views.conleadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'conleadgridview', parameterName: 'conleadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-con-lead-grid-view/lead-con-lead-grid-view.vue'),
                },
                {
                    path: 'leads/:lead?/conleadgridview/:conleadgridview?',
                    meta: {
                        caption: 'entities.lead.views.conleadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'conleadgridview', parameterName: 'conleadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-con-lead-grid-view/lead-con-lead-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.salesorder.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-view/sales-order-info-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.salesorder.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-view/sales-order-info-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.salesorder.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-view/sales-order-info-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.salesorder.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-view/sales-order-info-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.salesorder.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-view/sales-order-info-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.salesorder.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-info-view/sales-order-info-view.vue'),
                },
                {
                    path: 'knowledgearticles/:knowledgearticle?/info_klartview/:info_klartview?',
                    meta: {
                        caption: 'entities.knowledgearticle.views.info_klartview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'knowledgearticles', parameterName: 'knowledgearticle' },
                            { pathName: 'info_klartview', parameterName: 'info_klartview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/knowledge-article-info-kl-art-view/knowledge-article-info-kl-art-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-edit-view/sales-order-detail-edit-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-edit-view/sales-order-detail-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-edit-view/sales-order-detail-edit-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-edit-view/sales-order-detail-edit-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-edit-view/sales-order-detail-edit-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/salesorderdetails/:salesorderdetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-edit-view/sales-order-detail-edit-view.vue'),
                },
                {
                    path: 'salesorderdetails/:salesorderdetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.salesorderdetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorderdetails', parameterName: 'salesorderdetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-detail-edit-view/sales-order-detail-edit-view.vue'),
                },
                {
                    path: 'letters/:letter?/editview/:editview?',
                    meta: {
                        caption: 'entities.letter.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'letters', parameterName: 'letter' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/letter-edit-view/letter-edit-view.vue'),
                },
                {
                    path: 'transactioncurrencies/:transactioncurrency?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.transactioncurrency.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'transactioncurrencies', parameterName: 'transactioncurrency' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/transaction-currency-pickup-view/transaction-currency-pickup-view.vue'),
                },
                {
                    path: 'incidents/:incident?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.incident.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-summary-view/incident-summary-view.vue'),
                },
                {
                    path: 'metrics/:metric?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.metric.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'metrics', parameterName: 'metric' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/metric-pickup-grid-view/metric-pickup-grid-view.vue'),
                },
                {
                    path: 'goals/:goal?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.goal.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-grid-view/goal-grid-view.vue'),
                },
                {
                    path: 'subjects/:subject?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.subject.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'subjects', parameterName: 'subject' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/subject-pickup-grid-view/subject-pickup-grid-view.vue'),
                },
                {
                    path: 'products/:product?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.product.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-info-view/product-info-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/summary/:summary?',
                    meta: {
                        caption: 'entities.competitor.views.summary.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'summary', parameterName: 'summary' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-summary/competitor-summary.vue'),
                },
                {
                    path: 'goals/:goal?/edit_childgoalview/:edit_childgoalview?',
                    meta: {
                        caption: 'entities.goal.views.edit_childgoalview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'edit_childgoalview', parameterName: 'edit_childgoalview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-edit-child-goal-view/goal-edit-child-goal-view.vue'),
                },
                {
                    path: 'products/:product?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.product.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-grid-view/product-grid-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/info_abstract/:info_abstract?',
                    meta: {
                        caption: 'entities.ibizlist.views.info_abstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'info_abstract', parameterName: 'info_abstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/ibiz-list-info-abstract/ibiz-list-info-abstract.vue'),
                },
                {
                    path: 'goals/:goal?/closegridview/:closegridview?',
                    meta: {
                        caption: 'entities.goal.views.closegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'closegridview', parameterName: 'closegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-close-grid-view/goal-close-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/edit_compoppview/:edit_compoppview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.edit_compoppview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'edit_compoppview', parameterName: 'edit_compoppview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-comp-opp-view/opportunity-competitor-edit-comp-opp-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/edit_compoppview/:edit_compoppview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.edit_compoppview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'edit_compoppview', parameterName: 'edit_compoppview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-comp-opp-view/opportunity-competitor-edit-comp-opp-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/edit_compoppview/:edit_compoppview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.edit_compoppview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'edit_compoppview', parameterName: 'edit_compoppview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-comp-opp-view/opportunity-competitor-edit-comp-opp-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/edit_compoppview/:edit_compoppview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.edit_compoppview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'edit_compoppview', parameterName: 'edit_compoppview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-comp-opp-view/opportunity-competitor-edit-comp-opp-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/opportunitycompetitors/:opportunitycompetitor?/edit_compoppview/:edit_compoppview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.edit_compoppview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'edit_compoppview', parameterName: 'edit_compoppview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-comp-opp-view/opportunity-competitor-edit-comp-opp-view.vue'),
                },
                {
                    path: 'opportunitycompetitors/:opportunitycompetitor?/edit_compoppview/:edit_compoppview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.edit_compoppview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'edit_compoppview', parameterName: 'edit_compoppview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-edit-comp-opp-view/opportunity-competitor-edit-comp-opp-view.vue'),
                },
                {
                    path: 'products/:product?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.product.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-edit-data-panel-view/product-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.lead.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-pickup-grid-view/lead-pickup-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.lead.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-pickup-grid-view/lead-pickup-grid-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.lead.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-pickup-grid-view/lead-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.lead.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-pickup-grid-view/lead-pickup-grid-view.vue'),
                },
                {
                    path: 'leads/:lead?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.lead.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-pickup-grid-view/lead-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.opportunity.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-pickup-view/opportunity-pickup-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.opportunity.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-pickup-view/opportunity-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.opportunity.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-pickup-view/opportunity-pickup-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.opportunity.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-pickup-view/opportunity-pickup-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.competitor.views.mpickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-mpickup-view/competitor-mpickup-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.ibizlist.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/ibiz-list-option-view/ibiz-list-option-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/info_abstract/:info_abstract?',
                    meta: {
                        caption: 'entities.contact.views.info_abstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'info_abstract', parameterName: 'info_abstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-info-abstract/contact-info-abstract.vue'),
                },
                {
                    path: 'contacts/:contact?/info_abstract/:info_abstract?',
                    meta: {
                        caption: 'entities.contact.views.info_abstract.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'info_abstract', parameterName: 'info_abstract' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-info-abstract/contact-info-abstract.vue'),
                },
                {
                    path: 'accounts/:account?/edit_datapanel/:edit_datapanel?',
                    meta: {
                        caption: 'entities.account.views.edit_datapanel.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'edit_datapanel', parameterName: 'edit_datapanel' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-edit-data-panel/account-edit-data-panel.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-edit-view/invoice-detail-edit-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-edit-view/invoice-detail-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-edit-view/invoice-detail-edit-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-edit-view/invoice-detail-edit-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-edit-view/invoice-detail-edit-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/invoicedetails/:invoicedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-edit-view/invoice-detail-edit-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/invoicedetails/:invoicedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-edit-view/invoice-detail-edit-view.vue'),
                },
                {
                    path: 'invoicedetails/:invoicedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.invoicedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoicedetails', parameterName: 'invoicedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-detail-edit-view/invoice-detail-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/compoppgridview/:compoppgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.compoppgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'compoppgridview', parameterName: 'compoppgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-comp-opp-grid-view/opportunity-competitor-comp-opp-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/compoppgridview/:compoppgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.compoppgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'compoppgridview', parameterName: 'compoppgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-comp-opp-grid-view/opportunity-competitor-comp-opp-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/compoppgridview/:compoppgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.compoppgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'compoppgridview', parameterName: 'compoppgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-comp-opp-grid-view/opportunity-competitor-comp-opp-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/opportunitycompetitors/:opportunitycompetitor?/compoppgridview/:compoppgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.compoppgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'compoppgridview', parameterName: 'compoppgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-comp-opp-grid-view/opportunity-competitor-comp-opp-grid-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/opportunitycompetitors/:opportunitycompetitor?/compoppgridview/:compoppgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.compoppgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'compoppgridview', parameterName: 'compoppgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-comp-opp-grid-view/opportunity-competitor-comp-opp-grid-view.vue'),
                },
                {
                    path: 'opportunitycompetitors/:opportunitycompetitor?/compoppgridview/:compoppgridview?',
                    meta: {
                        caption: 'entities.opportunitycompetitor.views.compoppgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunitycompetitors', parameterName: 'opportunitycompetitor' },
                            { pathName: 'compoppgridview', parameterName: 'compoppgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-competitor-comp-opp-grid-view/opportunity-competitor-comp-opp-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/lostgridview/:lostgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.lostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'lostgridview', parameterName: 'lostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-lost-grid-view/opportunity-lost-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/lostgridview/:lostgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.lostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'lostgridview', parameterName: 'lostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-lost-grid-view/opportunity-lost-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/lostgridview/:lostgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.lostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'lostgridview', parameterName: 'lostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-lost-grid-view/opportunity-lost-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/lostgridview/:lostgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.lostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'lostgridview', parameterName: 'lostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-lost-grid-view/opportunity-lost-grid-view.vue'),
                },
                {
                    path: 'products/:product?/productassociations/:productassociation?/editview/:editview?',
                    meta: {
                        caption: 'entities.productassociation.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'productassociations', parameterName: 'productassociation' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-association-edit-view/product-association-edit-view.vue'),
                },
                {
                    path: 'productassociations/:productassociation?/editview/:editview?',
                    meta: {
                        caption: 'entities.productassociation.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'productassociations', parameterName: 'productassociation' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-association-edit-view/product-association-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.salesorder.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-grid-view/sales-order-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.salesorder.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-grid-view/sales-order-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.salesorder.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-grid-view/sales-order-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.salesorder.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-grid-view/sales-order-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.salesorder.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-grid-view/sales-order-grid-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.salesorder.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-grid-view/sales-order-grid-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.ibizlist.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/ibiz-list-state-tab-view/ibiz-list-state-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/leadcompetitors/:leadcompetitor?/leadgridview/:leadgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.leadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'leadgridview', parameterName: 'leadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-lead-grid-view/lead-competitor-lead-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/leadcompetitors/:leadcompetitor?/leadgridview/:leadgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.leadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'leadgridview', parameterName: 'leadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-lead-grid-view/lead-competitor-lead-grid-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/leadcompetitors/:leadcompetitor?/leadgridview/:leadgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.leadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'leadgridview', parameterName: 'leadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-lead-grid-view/lead-competitor-lead-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/leadcompetitors/:leadcompetitor?/leadgridview/:leadgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.leadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'leadgridview', parameterName: 'leadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-lead-grid-view/lead-competitor-lead-grid-view.vue'),
                },
                {
                    path: 'leads/:lead?/leadcompetitors/:leadcompetitor?/leadgridview/:leadgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.leadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'leadgridview', parameterName: 'leadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-lead-grid-view/lead-competitor-lead-grid-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/leadcompetitors/:leadcompetitor?/leadgridview/:leadgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.leadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'leadgridview', parameterName: 'leadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-lead-grid-view/lead-competitor-lead-grid-view.vue'),
                },
                {
                    path: 'leadcompetitors/:leadcompetitor?/leadgridview/:leadgridview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.leadgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'leadgridview', parameterName: 'leadgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-lead-grid-view/lead-competitor-lead-grid-view.vue'),
                },
                {
                    path: 'metrics/:metric?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.metric.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'metrics', parameterName: 'metric' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/metric-pickup-view/metric-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/statustabview/:statustabview?',
                    meta: {
                        caption: 'entities.lead.views.statustabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'statustabview', parameterName: 'statustabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-status-tab-view/lead-status-tab-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/statustabview/:statustabview?',
                    meta: {
                        caption: 'entities.lead.views.statustabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'statustabview', parameterName: 'statustabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-status-tab-view/lead-status-tab-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/statustabview/:statustabview?',
                    meta: {
                        caption: 'entities.lead.views.statustabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'statustabview', parameterName: 'statustabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-status-tab-view/lead-status-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/statustabview/:statustabview?',
                    meta: {
                        caption: 'entities.lead.views.statustabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'statustabview', parameterName: 'statustabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-status-tab-view/lead-status-tab-view.vue'),
                },
                {
                    path: 'leads/:lead?/statustabview/:statustabview?',
                    meta: {
                        caption: 'entities.lead.views.statustabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'statustabview', parameterName: 'statustabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-status-tab-view/lead-status-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/editview/:editview?',
                    meta: {
                        caption: 'entities.lead.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-edit-view/lead-edit-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/editview/:editview?',
                    meta: {
                        caption: 'entities.lead.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-edit-view/lead-edit-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/editview/:editview?',
                    meta: {
                        caption: 'entities.lead.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-edit-view/lead-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/editview/:editview?',
                    meta: {
                        caption: 'entities.lead.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-edit-view/lead-edit-view.vue'),
                },
                {
                    path: 'leads/:lead?/editview/:editview?',
                    meta: {
                        caption: 'entities.lead.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-edit-view/lead-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.lead.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-quick-create/lead-quick-create.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.lead.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-quick-create/lead-quick-create.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.lead.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-quick-create/lead-quick-create.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.lead.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-quick-create/lead-quick-create.vue'),
                },
                {
                    path: 'leads/:lead?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.lead.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-quick-create/lead-quick-create.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.salesorder.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-quick-create-view/sales-order-quick-create-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.salesorder.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-quick-create-view/sales-order-quick-create-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.salesorder.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-quick-create-view/sales-order-quick-create-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.salesorder.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-quick-create-view/sales-order-quick-create-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.salesorder.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-quick-create-view/sales-order-quick-create-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/quickcreateview/:quickcreateview?',
                    meta: {
                        caption: 'entities.salesorder.views.quickcreateview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'quickcreateview', parameterName: 'quickcreateview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-quick-create-view/sales-order-quick-create-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.competitor.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-pickup-grid-view/competitor-pickup-grid-view.vue'),
                },
                {
                    path: 'pricelevels/:pricelevel?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.pricelevel.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'pricelevels', parameterName: 'pricelevel' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/price-level-pickup-view/price-level-pickup-view.vue'),
                },
                {
                    path: 'incidentcustomers/:incidentcustomer?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.incidentcustomer.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidentcustomers', parameterName: 'incidentcustomer' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-customer-pickup-view/incident-customer-pickup-view.vue'),
                },
                {
                    path: 'goals/:goal?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.goal.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-state-tab-view/goal-state-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunity.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-edit-view/opportunity-edit-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunity.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-edit-view/opportunity-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunity.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-edit-view/opportunity-edit-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/editview/:editview?',
                    meta: {
                        caption: 'entities.opportunity.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-edit-view/opportunity-edit-view.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/salesliteratureitems/:salesliteratureitem?/editview/:editview?',
                    meta: {
                        caption: 'entities.salesliteratureitem.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'salesliteratureitems', parameterName: 'salesliteratureitem' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-literature-item-edit-view/sales-literature-item-edit-view.vue'),
                },
                {
                    path: 'salesliteratureitems/:salesliteratureitem?/editview/:editview?',
                    meta: {
                        caption: 'entities.salesliteratureitem.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratureitems', parameterName: 'salesliteratureitem' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-literature-item-edit-view/sales-literature-item-edit-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.competitor.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-grid-view/competitor-grid-view.vue'),
                },
                {
                    path: 'incidents/:incident?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.incident.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-pickup-grid-view/incident-pickup-grid-view.vue'),
                },
                {
                    path: 'incidents/:incident?/quickcreatebyparentkey/:quickcreatebyparentkey?',
                    meta: {
                        caption: 'entities.incident.views.quickcreatebyparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'quickcreatebyparentkey', parameterName: 'quickcreatebyparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-quick-create-by-parent-key/incident-quick-create-by-parent-key.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.ibizlist.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/ibiz-list-quick-create/ibiz-list-quick-create.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/opportunityproducts/:opportunityproduct?/opp_oppprogridview/:opp_oppprogridview?',
                    meta: {
                        caption: 'entities.opportunityproduct.views.opp_oppprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunityproducts', parameterName: 'opportunityproduct' },
                            { pathName: 'opp_oppprogridview', parameterName: 'opp_oppprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-product-opp-opp-pro-grid-view/opportunity-product-opp-opp-pro-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/opportunityproducts/:opportunityproduct?/opp_oppprogridview/:opp_oppprogridview?',
                    meta: {
                        caption: 'entities.opportunityproduct.views.opp_oppprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunityproducts', parameterName: 'opportunityproduct' },
                            { pathName: 'opp_oppprogridview', parameterName: 'opp_oppprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-product-opp-opp-pro-grid-view/opportunity-product-opp-opp-pro-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/opportunityproducts/:opportunityproduct?/opp_oppprogridview/:opp_oppprogridview?',
                    meta: {
                        caption: 'entities.opportunityproduct.views.opp_oppprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunityproducts', parameterName: 'opportunityproduct' },
                            { pathName: 'opp_oppprogridview', parameterName: 'opp_oppprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-product-opp-opp-pro-grid-view/opportunity-product-opp-opp-pro-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/opportunityproducts/:opportunityproduct?/opp_oppprogridview/:opp_oppprogridview?',
                    meta: {
                        caption: 'entities.opportunityproduct.views.opp_oppprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'opportunityproducts', parameterName: 'opportunityproduct' },
                            { pathName: 'opp_oppprogridview', parameterName: 'opp_oppprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-product-opp-opp-pro-grid-view/opportunity-product-opp-opp-pro-grid-view.vue'),
                },
                {
                    path: 'opportunityproducts/:opportunityproduct?/opp_oppprogridview/:opp_oppprogridview?',
                    meta: {
                        caption: 'entities.opportunityproduct.views.opp_oppprogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunityproducts', parameterName: 'opportunityproduct' },
                            { pathName: 'opp_oppprogridview', parameterName: 'opp_oppprogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-product-opp-opp-pro-grid-view/opportunity-product-opp-opp-pro-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.contact.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-tab-exp-view/contact-tab-exp-view.vue'),
                },
                {
                    path: 'contacts/:contact?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.contact.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-tab-exp-view/contact-tab-exp-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.lead.views.mpickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-mpickup-view/lead-mpickup-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.lead.views.mpickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-mpickup-view/lead-mpickup-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.lead.views.mpickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-mpickup-view/lead-mpickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.lead.views.mpickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-mpickup-view/lead-mpickup-view.vue'),
                },
                {
                    path: 'leads/:lead?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.lead.views.mpickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-mpickup-view/lead-mpickup-view.vue'),
                },
                {
                    path: 'products/:product?/productassociations/:productassociation?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.productassociation.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'productassociations', parameterName: 'productassociation' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-association-grid-view/product-association-grid-view.vue'),
                },
                {
                    path: 'productassociations/:productassociation?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.productassociation.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'productassociations', parameterName: 'productassociation' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-association-grid-view/product-association-grid-view.vue'),
                },
                {
                    path: 'transactioncurrencies/:transactioncurrency?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.transactioncurrency.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'transactioncurrencies', parameterName: 'transactioncurrency' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/transaction-currency-grid-view/transaction-currency-grid-view.vue'),
                },
                {
                    path: 'appointments/:appointment?/quickcreate/:quickcreate?',
                    meta: {
                        caption: 'entities.appointment.views.quickcreate.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'appointments', parameterName: 'appointment' },
                            { pathName: 'quickcreate', parameterName: 'quickcreate' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/appointment-quick-create/appointment-quick-create.vue'),
                },
                {
                    path: 'incidentcustomers/:incidentcustomer?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.incidentcustomer.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidentcustomers', parameterName: 'incidentcustomer' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-customer-pickup-grid-view/incident-customer-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.account.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-by-parent-key/account-by-parent-key.vue'),
                },
                {
                    path: 'campaignresponses/:campaignresponse?/editview/:editview?',
                    meta: {
                        caption: 'entities.campaignresponse.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaignresponses', parameterName: 'campaignresponse' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-response-edit-view/campaign-response-edit-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/info/:info?',
                    meta: {
                        caption: 'entities.campaign.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-info/campaign-info.vue'),
                },
                {
                    path: 'products/:product?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.product.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-summary-view/product-summary-view.vue'),
                },
                {
                    path: 'accounts/:account?/edit_address/:edit_address?',
                    meta: {
                        caption: 'entities.account.views.edit_address.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'edit_address', parameterName: 'edit_address' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-edit-address/account-edit-address.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.quote.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-grid-view/quote-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.quote.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-grid-view/quote-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.quote.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-grid-view/quote-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.quote.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-grid-view/quote-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.quote.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-grid-view/quote-grid-view.vue'),
                },
                {
                    path: 'connections/:connection?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.connection.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'connections', parameterName: 'connection' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/runtime/connection-by-parent-key/connection-by-parent-key.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.quote.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-option-view/quote-option-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.quote.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-option-view/quote-option-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.quote.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-option-view/quote-option-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.quote.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-option-view/quote-option-view.vue'),
                },
                {
                    path: 'quotes/:quote?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.quote.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-option-view/quote-option-view.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/info_sallitview/:info_sallitview?',
                    meta: {
                        caption: 'entities.salesliterature.views.info_sallitview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'info_sallitview', parameterName: 'info_sallitview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-literature-info-sal-lit-view/sales-literature-info-sal-lit-view.vue'),
                },
                {
                    path: 'goals/:goal?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.goal.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-pickup-view/goal-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.salesorder.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-state-tab-view/sales-order-state-tab-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.salesorder.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-state-tab-view/sales-order-state-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.salesorder.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-state-tab-view/sales-order-state-tab-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.salesorder.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-state-tab-view/sales-order-state-tab-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.salesorder.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-state-tab-view/sales-order-state-tab-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/statetabview/:statetabview?',
                    meta: {
                        caption: 'entities.salesorder.views.statetabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'statetabview', parameterName: 'statetabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-state-tab-view/sales-order-state-tab-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.contact.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-pickup-view/contact-pickup-view.vue'),
                },
                {
                    path: 'contacts/:contact?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.contact.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-pickup-view/contact-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/listcontacts/:listcontact?/inner/:inner?',
                    meta: {
                        caption: 'entities.listcontact.views.inner.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'inner', parameterName: 'inner' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-inner/list-contact-inner.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/listcontacts/:listcontact?/inner/:inner?',
                    meta: {
                        caption: 'entities.listcontact.views.inner.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'inner', parameterName: 'inner' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-inner/list-contact-inner.vue'),
                },
                {
                    path: 'contacts/:contact?/listcontacts/:listcontact?/inner/:inner?',
                    meta: {
                        caption: 'entities.listcontact.views.inner.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'inner', parameterName: 'inner' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-inner/list-contact-inner.vue'),
                },
                {
                    path: 'listcontacts/:listcontact?/inner/:inner?',
                    meta: {
                        caption: 'entities.listcontact.views.inner.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'listcontacts', parameterName: 'listcontact' },
                            { pathName: 'inner', parameterName: 'inner' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-contact-inner/list-contact-inner.vue'),
                },
                {
                    path: 'campaigns/:campaign?/info_campagin/:info_campagin?',
                    meta: {
                        caption: 'entities.campaign.views.info_campagin.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'info_campagin', parameterName: 'info_campagin' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-info-campagin/campaign-info-campagin.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/editview/:editview?',
                    meta: {
                        caption: 'entities.contact.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-edit-view/contact-edit-view.vue'),
                },
                {
                    path: 'contacts/:contact?/editview/:editview?',
                    meta: {
                        caption: 'entities.contact.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-edit-view/contact-edit-view.vue'),
                },
                {
                    path: 'appointments/:appointment?/editview/:editview?',
                    meta: {
                        caption: 'entities.appointment.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'appointments', parameterName: 'appointment' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/appointment-edit-view/appointment-edit-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/listaccounts/:listaccount?/editview/:editview?',
                    meta: {
                        caption: 'entities.listaccount.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-edit-view/list-account-edit-view.vue'),
                },
                {
                    path: 'accounts/:account?/listaccounts/:listaccount?/editview/:editview?',
                    meta: {
                        caption: 'entities.listaccount.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-edit-view/list-account-edit-view.vue'),
                },
                {
                    path: 'listaccounts/:listaccount?/editview/:editview?',
                    meta: {
                        caption: 'entities.listaccount.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-edit-view/list-account-edit-view.vue'),
                },
                {
                    path: 'entitlements/:entitlement?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.entitlement.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'entitlements', parameterName: 'entitlement' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/entitlement-pickup-grid-view/entitlement-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.contact.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-grid-view/contact-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.contact.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-grid-view/contact-grid-view.vue'),
                },
                {
                    path: 'campaignactivities/:campaignactivity?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.campaignactivity.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaignactivities', parameterName: 'campaignactivity' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-activity-by-parent-key/campaign-activity-by-parent-key.vue'),
                },
                {
                    path: 'pricelevels/:pricelevel?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.pricelevel.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'pricelevels', parameterName: 'pricelevel' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/price-level-pickup-grid-view/price-level-pickup-grid-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/effectivegridview/:effectivegridview?',
                    meta: {
                        caption: 'entities.ibizlist.views.effectivegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'effectivegridview', parameterName: 'effectivegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/ibiz-list-effective-grid-view/ibiz-list-effective-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/oppquagridview/:oppquagridview?',
                    meta: {
                        caption: 'entities.quote.views.oppquagridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'oppquagridview', parameterName: 'oppquagridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-opp-qua-grid-view/quote-opp-qua-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/oppquagridview/:oppquagridview?',
                    meta: {
                        caption: 'entities.quote.views.oppquagridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'oppquagridview', parameterName: 'oppquagridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-opp-qua-grid-view/quote-opp-qua-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/oppquagridview/:oppquagridview?',
                    meta: {
                        caption: 'entities.quote.views.oppquagridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'oppquagridview', parameterName: 'oppquagridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-opp-qua-grid-view/quote-opp-qua-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/oppquagridview/:oppquagridview?',
                    meta: {
                        caption: 'entities.quote.views.oppquagridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'oppquagridview', parameterName: 'oppquagridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-opp-qua-grid-view/quote-opp-qua-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/oppquagridview/:oppquagridview?',
                    meta: {
                        caption: 'entities.quote.views.oppquagridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'oppquagridview', parameterName: 'oppquagridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/quote-opp-qua-grid-view/quote-opp-qua-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.invoice.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-edit-data-panel-view/invoice-edit-data-panel-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.invoice.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-edit-data-panel-view/invoice-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.invoice.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-edit-data-panel-view/invoice-edit-data-panel-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.invoice.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-edit-data-panel-view/invoice-edit-data-panel-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.invoice.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-edit-data-panel-view/invoice-edit-data-panel-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.invoice.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-edit-data-panel-view/invoice-edit-data-panel-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.invoice.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-edit-data-panel-view/invoice-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/treegridexview/:treegridexview?',
                    meta: {
                        caption: 'entities.account.views.treegridexview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'treegridexview', parameterName: 'treegridexview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-tree-grid-ex-view/account-tree-grid-ex-view.vue'),
                },
                {
                    path: 'incidents/:incident?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.incident.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-by-parent-key/incident-by-parent-key.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/qualification/:qualification?',
                    meta: {
                        caption: 'entities.lead.views.qualification.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'qualification', parameterName: 'qualification' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-qualification/lead-qualification.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/qualification/:qualification?',
                    meta: {
                        caption: 'entities.lead.views.qualification.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'qualification', parameterName: 'qualification' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-qualification/lead-qualification.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/qualification/:qualification?',
                    meta: {
                        caption: 'entities.lead.views.qualification.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'qualification', parameterName: 'qualification' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-qualification/lead-qualification.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/qualification/:qualification?',
                    meta: {
                        caption: 'entities.lead.views.qualification.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'qualification', parameterName: 'qualification' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-qualification/lead-qualification.vue'),
                },
                {
                    path: 'leads/:lead?/qualification/:qualification?',
                    meta: {
                        caption: 'entities.lead.views.qualification.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'qualification', parameterName: 'qualification' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-qualification/lead-qualification.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/competitorsalesliteratures/:competitorsalesliterature?/sallitcompgridview/:sallitcompgridview?',
                    meta: {
                        caption: 'entities.competitorsalesliterature.views.sallitcompgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'competitorsalesliteratures', parameterName: 'competitorsalesliterature' },
                            { pathName: 'sallitcompgridview', parameterName: 'sallitcompgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-sales-literature-sal-lit-comp-grid-view/competitor-sales-literature-sal-lit-comp-grid-view.vue'),
                },
                {
                    path: 'competitorsalesliteratures/:competitorsalesliterature?/sallitcompgridview/:sallitcompgridview?',
                    meta: {
                        caption: 'entities.competitorsalesliterature.views.sallitcompgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitorsalesliteratures', parameterName: 'competitorsalesliterature' },
                            { pathName: 'sallitcompgridview', parameterName: 'sallitcompgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-sales-literature-sal-lit-comp-grid-view/competitor-sales-literature-sal-lit-comp-grid-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.campaign.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-pickup-grid-view/campaign-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/statustabview/:statustabview?',
                    meta: {
                        caption: 'entities.account.views.statustabview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'statustabview', parameterName: 'statustabview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-status-tab-view/account-status-tab-view.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/salesliteratureitems/:salesliteratureitem?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.salesliteratureitem.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'salesliteratureitems', parameterName: 'salesliteratureitem' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-literature-item-grid-view/sales-literature-item-grid-view.vue'),
                },
                {
                    path: 'salesliteratureitems/:salesliteratureitem?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.salesliteratureitem.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratureitems', parameterName: 'salesliteratureitem' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-literature-item-grid-view/sales-literature-item-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.lead.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-dashboard-view/lead-dashboard-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.lead.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-dashboard-view/lead-dashboard-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.lead.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-dashboard-view/lead-dashboard-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.lead.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-dashboard-view/lead-dashboard-view.vue'),
                },
                {
                    path: 'leads/:lead?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.lead.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-dashboard-view/lead-dashboard-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/listaccounts/:listaccount?/quickcreatebylist/:quickcreatebylist?',
                    meta: {
                        caption: 'entities.listaccount.views.quickcreatebylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'quickcreatebylist', parameterName: 'quickcreatebylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-quick-create-by-list/list-account-quick-create-by-list.vue'),
                },
                {
                    path: 'accounts/:account?/listaccounts/:listaccount?/quickcreatebylist/:quickcreatebylist?',
                    meta: {
                        caption: 'entities.listaccount.views.quickcreatebylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'quickcreatebylist', parameterName: 'quickcreatebylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-quick-create-by-list/list-account-quick-create-by-list.vue'),
                },
                {
                    path: 'listaccounts/:listaccount?/quickcreatebylist/:quickcreatebylist?',
                    meta: {
                        caption: 'entities.listaccount.views.quickcreatebylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'quickcreatebylist', parameterName: 'quickcreatebylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-quick-create-by-list/list-account-quick-create-by-list.vue'),
                },
                {
                    path: 'accounts/:account?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.account.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-pickup-grid-view/account-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.salesorder.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-by-parent-key/sales-order-by-parent-key.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.salesorder.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-by-parent-key/sales-order-by-parent-key.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.salesorder.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-by-parent-key/sales-order-by-parent-key.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.salesorder.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-by-parent-key/sales-order-by-parent-key.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.salesorder.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-by-parent-key/sales-order-by-parent-key.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.salesorder.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/sales-order-by-parent-key/sales-order-by-parent-key.vue'),
                },
                {
                    path: 'products/:product?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.product.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-pickup-grid-view/product-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/listleads/:listlead?/quickcreatebylist/:quickcreatebylist?',
                    meta: {
                        caption: 'entities.listlead.views.quickcreatebylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'quickcreatebylist', parameterName: 'quickcreatebylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-quick-create-by-list/list-lead-quick-create-by-list.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/listleads/:listlead?/quickcreatebylist/:quickcreatebylist?',
                    meta: {
                        caption: 'entities.listlead.views.quickcreatebylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'quickcreatebylist', parameterName: 'quickcreatebylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-quick-create-by-list/list-lead-quick-create-by-list.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/listleads/:listlead?/quickcreatebylist/:quickcreatebylist?',
                    meta: {
                        caption: 'entities.listlead.views.quickcreatebylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'quickcreatebylist', parameterName: 'quickcreatebylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-quick-create-by-list/list-lead-quick-create-by-list.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/listleads/:listlead?/quickcreatebylist/:quickcreatebylist?',
                    meta: {
                        caption: 'entities.listlead.views.quickcreatebylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'quickcreatebylist', parameterName: 'quickcreatebylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-quick-create-by-list/list-lead-quick-create-by-list.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/listleads/:listlead?/quickcreatebylist/:quickcreatebylist?',
                    meta: {
                        caption: 'entities.listlead.views.quickcreatebylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'quickcreatebylist', parameterName: 'quickcreatebylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-quick-create-by-list/list-lead-quick-create-by-list.vue'),
                },
                {
                    path: 'leads/:lead?/listleads/:listlead?/quickcreatebylist/:quickcreatebylist?',
                    meta: {
                        caption: 'entities.listlead.views.quickcreatebylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'quickcreatebylist', parameterName: 'quickcreatebylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-quick-create-by-list/list-lead-quick-create-by-list.vue'),
                },
                {
                    path: 'listleads/:listlead?/quickcreatebylist/:quickcreatebylist?',
                    meta: {
                        caption: 'entities.listlead.views.quickcreatebylist.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'listleads', parameterName: 'listlead' },
                            { pathName: 'quickcreatebylist', parameterName: 'quickcreatebylist' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-lead-quick-create-by-list/list-lead-quick-create-by-list.vue'),
                },
                {
                    path: 'accounts/:account?/info/:info?',
                    meta: {
                        caption: 'entities.account.views.info.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'info', parameterName: 'info' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-info/account-info.vue'),
                },
                {
                    path: 'goals/:goal?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.goal.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-summary-view/goal-summary-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-pickup-grid-view/opportunity-pickup-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-pickup-grid-view/opportunity-pickup-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-pickup-grid-view/opportunity-pickup-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.opportunity.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/opportunity-pickup-grid-view/opportunity-pickup-grid-view.vue'),
                },
                {
                    path: 'metrics/:metric?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.metric.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'metrics', parameterName: 'metric' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/metric-grid-view/metric-grid-view.vue'),
                },
                {
                    path: 'connectionroles/:connectionrole?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.connectionrole.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'connectionroles', parameterName: 'connectionrole' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/runtime/connection-role-grid-view/connection-role-grid-view.vue'),
                },
                {
                    path: 'incidents/:incident?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.incident.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'incidents', parameterName: 'incident' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/incident-pickup-view/incident-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.contact.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-edit-data-panel-view/contact-edit-data-panel-view.vue'),
                },
                {
                    path: 'contacts/:contact?/edit_datapanelview/:edit_datapanelview?',
                    meta: {
                        caption: 'entities.contact.views.edit_datapanelview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'edit_datapanelview', parameterName: 'edit_datapanelview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-edit-data-panel-view/contact-edit-data-panel-view.vue'),
                },
                {
                    path: 'accounts/:account?/info_all/:info_all?',
                    meta: {
                        caption: 'entities.account.views.info_all.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'info_all', parameterName: 'info_all' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-info-all/account-info-all.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/stopgridview/:stopgridview?',
                    meta: {
                        caption: 'entities.contact.views.stopgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'stopgridview', parameterName: 'stopgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-stop-grid-view/contact-stop-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/stopgridview/:stopgridview?',
                    meta: {
                        caption: 'entities.contact.views.stopgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'stopgridview', parameterName: 'stopgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-stop-grid-view/contact-stop-grid-view.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/competitorsalesliteratures/:competitorsalesliterature?/sallitcompeditview/:sallitcompeditview?',
                    meta: {
                        caption: 'entities.competitorsalesliterature.views.sallitcompeditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'competitorsalesliteratures', parameterName: 'competitorsalesliterature' },
                            { pathName: 'sallitcompeditview', parameterName: 'sallitcompeditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-sales-literature-sal-lit-comp-edit-view/competitor-sales-literature-sal-lit-comp-edit-view.vue'),
                },
                {
                    path: 'competitorsalesliteratures/:competitorsalesliterature?/sallitcompeditview/:sallitcompeditview?',
                    meta: {
                        caption: 'entities.competitorsalesliterature.views.sallitcompeditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitorsalesliteratures', parameterName: 'competitorsalesliterature' },
                            { pathName: 'sallitcompeditview', parameterName: 'sallitcompeditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-sales-literature-sal-lit-comp-edit-view/competitor-sales-literature-sal-lit-comp-edit-view.vue'),
                },
                {
                    path: 'activitypointers/:activitypointer?/byparentkey/:byparentkey?',
                    meta: {
                        caption: 'entities.activitypointer.views.byparentkey.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'activitypointers', parameterName: 'activitypointer' },
                            { pathName: 'byparentkey', parameterName: 'byparentkey' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/activity-pointer-by-parent-key/activity-pointer-by-parent-key.vue'),
                },
                {
                    path: 'entitlements/:entitlement?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.entitlement.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'entitlements', parameterName: 'entitlement' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/service/entitlement-pickup-view/entitlement-pickup-view.vue'),
                },
                {
                    path: 'uoms/:uom?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.uom.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'uoms', parameterName: 'uom' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/uom-pickup-view/uom-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/leads/:lead?/leadcompetitors/:leadcompetitor?/edit_competitorview/:edit_competitorview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.edit_competitorview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'edit_competitorview', parameterName: 'edit_competitorview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-edit-competitor-view/lead-competitor-edit-competitor-view.vue'),
                },
                {
                    path: 'contacts/:contact?/leads/:lead?/leadcompetitors/:leadcompetitor?/edit_competitorview/:edit_competitorview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.edit_competitorview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'edit_competitorview', parameterName: 'edit_competitorview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-edit-competitor-view/lead-competitor-edit-competitor-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/leads/:lead?/leadcompetitors/:leadcompetitor?/edit_competitorview/:edit_competitorview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.edit_competitorview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'edit_competitorview', parameterName: 'edit_competitorview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-edit-competitor-view/lead-competitor-edit-competitor-view.vue'),
                },
                {
                    path: 'accounts/:account?/leads/:lead?/leadcompetitors/:leadcompetitor?/edit_competitorview/:edit_competitorview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.edit_competitorview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'edit_competitorview', parameterName: 'edit_competitorview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-edit-competitor-view/lead-competitor-edit-competitor-view.vue'),
                },
                {
                    path: 'leads/:lead?/leadcompetitors/:leadcompetitor?/edit_competitorview/:edit_competitorview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.edit_competitorview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leads', parameterName: 'lead' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'edit_competitorview', parameterName: 'edit_competitorview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-edit-competitor-view/lead-competitor-edit-competitor-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/leadcompetitors/:leadcompetitor?/edit_competitorview/:edit_competitorview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.edit_competitorview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'edit_competitorview', parameterName: 'edit_competitorview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-edit-competitor-view/lead-competitor-edit-competitor-view.vue'),
                },
                {
                    path: 'leadcompetitors/:leadcompetitor?/edit_competitorview/:edit_competitorview?',
                    meta: {
                        caption: 'entities.leadcompetitor.views.edit_competitorview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'leadcompetitors', parameterName: 'leadcompetitor' },
                            { pathName: 'edit_competitorview', parameterName: 'edit_competitorview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/lead-competitor-edit-competitor-view/lead-competitor-edit-competitor-view.vue'),
                },
                {
                    path: 'ibizlists/:ibizlist?/listaccounts/:listaccount?/inner/:inner?',
                    meta: {
                        caption: 'entities.listaccount.views.inner.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'ibizlists', parameterName: 'ibizlist' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'inner', parameterName: 'inner' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-inner/list-account-inner.vue'),
                },
                {
                    path: 'accounts/:account?/listaccounts/:listaccount?/inner/:inner?',
                    meta: {
                        caption: 'entities.listaccount.views.inner.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'inner', parameterName: 'inner' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-inner/list-account-inner.vue'),
                },
                {
                    path: 'listaccounts/:listaccount?/inner/:inner?',
                    meta: {
                        caption: 'entities.listaccount.views.inner.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'listaccounts', parameterName: 'listaccount' },
                            { pathName: 'inner', parameterName: 'inner' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/list-account-inner/list-account-inner.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.contact.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-summary-view/contact-summary-view.vue'),
                },
                {
                    path: 'contacts/:contact?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.contact.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/contact-summary-view/contact-summary-view.vue'),
                },
                {
                    path: 'tasks/:task?/editview/:editview?',
                    meta: {
                        caption: 'entities.task.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'tasks', parameterName: 'task' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/task-edit-view/task-edit-view.vue'),
                },
                {
                    path: 'products/:product?/productsubstitutes/:productsubstitute?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.productsubstitute.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'productsubstitutes', parameterName: 'productsubstitute' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-substitute-grid-view/product-substitute-grid-view.vue'),
                },
                {
                    path: 'productsubstitutes/:productsubstitute?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.productsubstitute.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'productsubstitutes', parameterName: 'productsubstitute' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-substitute-grid-view/product-substitute-grid-view.vue'),
                },
                {
                    path: 'goals/:goal?/usablegridview/:usablegridview?',
                    meta: {
                        caption: 'entities.goal.views.usablegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'goals', parameterName: 'goal' },
                            { pathName: 'usablegridview', parameterName: 'usablegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/goal-usable-grid-view/goal-usable-grid-view.vue'),
                },
                {
                    path: 'competitors/:competitor?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.competitor.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'competitors', parameterName: 'competitor' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/competitor-pickup-view/competitor-pickup-view.vue'),
                },
                {
                    path: 'accounts/:account?/contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.invoice.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-cancel-grid-view/invoice-cancel-grid-view.vue'),
                },
                {
                    path: 'contacts/:contact?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.invoice.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'contacts', parameterName: 'contact' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-cancel-grid-view/invoice-cancel-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.invoice.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-cancel-grid-view/invoice-cancel-grid-view.vue'),
                },
                {
                    path: 'opportunities/:opportunity?/quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.invoice.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'opportunities', parameterName: 'opportunity' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-cancel-grid-view/invoice-cancel-grid-view.vue'),
                },
                {
                    path: 'quotes/:quote?/salesorders/:salesorder?/invoices/:invoice?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.invoice.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'quotes', parameterName: 'quote' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-cancel-grid-view/invoice-cancel-grid-view.vue'),
                },
                {
                    path: 'salesorders/:salesorder?/invoices/:invoice?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.invoice.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesorders', parameterName: 'salesorder' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-cancel-grid-view/invoice-cancel-grid-view.vue'),
                },
                {
                    path: 'invoices/:invoice?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.invoice.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'invoices', parameterName: 'invoice' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/finance/invoice-cancel-grid-view/invoice-cancel-grid-view.vue'),
                },
                {
                    path: 'salesliteratures/:salesliterature?/productsalesliteratures/:productsalesliterature?/sallitproeditview/:sallitproeditview?',
                    meta: {
                        caption: 'entities.productsalesliterature.views.sallitproeditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'salesliteratures', parameterName: 'salesliterature' },
                            { pathName: 'productsalesliteratures', parameterName: 'productsalesliterature' },
                            { pathName: 'sallitproeditview', parameterName: 'sallitproeditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/product-sales-literature-sal-lit-pro-edit-view/product-sales-literature-sal-lit-pro-edit-view.vue'),
                },
                {
                    path: 'productsalesliteratures/:productsalesliterature?/sallitproeditview/:sallitproeditview?',
                    meta: {
                        caption: 'entities.productsalesliterature.views.sallitproeditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'productsalesliteratures', parameterName: 'productsalesliterature' },
                            { pathName: 'sallitproeditview', parameterName: 'sallitproeditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sales/product-sales-literature-sal-lit-pro-edit-view/product-sales-literature-sal-lit-pro-edit-view.vue'),
                },
                {
                    path: 'campaigns/:campaign?/stopgridview/:stopgridview?',
                    meta: {
                        caption: 'entities.campaign.views.stopgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'campaigns', parameterName: 'campaign' },
                            { pathName: 'stopgridview', parameterName: 'stopgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/marketing/campaign-stop-grid-view/campaign-stop-grid-view.vue'),
                },
                {
                    path: 'products/:product?/effectivegridview/:effectivegridview?',
                    meta: {
                        caption: 'entities.product.views.effectivegridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'products', parameterName: 'product' },
                            { pathName: 'effectivegridview', parameterName: 'effectivegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/product/product-effective-grid-view/product-effective-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/stopgridview/:stopgridview?',
                    meta: {
                        caption: 'entities.account.views.stopgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'stopgridview', parameterName: 'stopgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-stop-grid-view/account-stop-grid-view.vue'),
                },
                {
                    path: 'accounts/:account?/edit_accountinfo/:edit_accountinfo?',
                    meta: {
                        caption: 'entities.account.views.edit_accountinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'accounts', parameterName: 'account' },
                            { pathName: 'edit_accountinfo', parameterName: 'edit_accountinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/base/account-edit-account-info/account-edit-account-info.vue'),
                },
                {
                    path: 'connectionroles/:connectionrole?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.connectionrole.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'central', parameterName: 'central' },
                            { pathName: 'connectionroles', parameterName: 'connectionrole' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/runtime/connection-role-pickup-grid-view/connection-role-pickup-grid-view.vue'),
                },
            {
                path: 'activitypointerredirectview/:activitypointerredirectview?',
                meta: {
                    caption: 'entities.activitypointer.views.redirectview.title',
                    info:'',
                    parameters: [
                        { pathName: 'activitypointerredirectview', parameterName: 'activitypointerredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/base/activity-pointer-redirect-view/activity-pointer-redirect-view.vue'),
            },
            ...indexRoutes,
            ],
        },
        ...globalRoutes,
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                appService.navHistory.reset();
                next();
            },
            component: () => import('@components/login/login.vue'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'central'
        }
    ]
});

router.beforeEach((to: any, from: any, next: any) => {
    if (to.meta && !to.meta.ignoreAddPage) {
        appService.navHistory.add(to);
    }
    next();
});

export default router;