import AuthService from '../auth-service';

/**
 * 计价单位组权限服务对象基类
 *
 * @export
 * @class UomScheduleAuthServiceBase
 * @extends {AuthService}
 */
export default class UomScheduleAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  UomScheduleAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  UomScheduleAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof UomScheduleAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}