import AuthService from '../auth-service';

/**
 * 货币权限服务对象基类
 *
 * @export
 * @class TransactionCurrencyAuthServiceBase
 * @extends {AuthService}
 */
export default class TransactionCurrencyAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  TransactionCurrencyAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  TransactionCurrencyAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof TransactionCurrencyAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}