import AuthService from '../auth-service';

/**
 * 主题权限服务对象基类
 *
 * @export
 * @class SubjectAuthServiceBase
 * @extends {AuthService}
 */
export default class SubjectAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  SubjectAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  SubjectAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof SubjectAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}