import AuthService from '../auth-service';

/**
 * 订单产品权限服务对象基类
 *
 * @export
 * @class SalesOrderDetailAuthServiceBase
 * @extends {AuthService}
 */
export default class SalesOrderDetailAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  SalesOrderDetailAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  SalesOrderDetailAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof SalesOrderDetailAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}