import AuthService from '../auth-service';

/**
 * 销售附件权限服务对象基类
 *
 * @export
 * @class SalesLiteratureItemAuthServiceBase
 * @extends {AuthService}
 */
export default class SalesLiteratureItemAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  SalesLiteratureItemAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  SalesLiteratureItemAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof SalesLiteratureItemAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}