import AuthService from '../auth-service';

/**
 * 报价单产品权限服务对象基类
 *
 * @export
 * @class QuoteDetailAuthServiceBase
 * @extends {AuthService}
 */
export default class QuoteDetailAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  QuoteDetailAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  QuoteDetailAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof QuoteDetailAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}