import AuthService from '../auth-service';

/**
 * 产品替换权限服务对象基类
 *
 * @export
 * @class ProductSubstituteAuthServiceBase
 * @extends {AuthService}
 */
export default class ProductSubstituteAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  ProductSubstituteAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ProductSubstituteAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof ProductSubstituteAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}