import AuthService from '../auth-service';

/**
 * 价目表项权限服务对象基类
 *
 * @export
 * @class ProductPriceLevelAuthServiceBase
 * @extends {AuthService}
 */
export default class ProductPriceLevelAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  ProductPriceLevelAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ProductPriceLevelAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof ProductPriceLevelAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}