import AuthService from '../auth-service';

/**
 * 价目表权限服务对象基类
 *
 * @export
 * @class PriceLevelAuthServiceBase
 * @extends {AuthService}
 */
export default class PriceLevelAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  PriceLevelAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  PriceLevelAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof PriceLevelAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}